package bookExamples.ch26Graphics.draw2d;

import futils.Futil;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class ZoomDemo extends JFrame {
    private ZoomTargetPanel zoomtargetpanel;
    private ZoomSourcePanel zoomsourcepanel;
    private String imagefile;

    public ZoomDemo(String imagefile) {
        JButton b = new JButton("Image Source...");
        b.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent evt) {
                setSource();
            }
        });

        zoomtargetpanel = new ZoomTargetPanel();

        getContentPane().add(b, BorderLayout.NORTH);
        getContentPane().add(zoomtargetpanel);
        setSize(new Dimension(300, 300));
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

        this.imagefile = imagefile;
    }

    private void setSource() {
        zoomsourcepanel = new ZoomSourcePanel(imagefile, zoomtargetpanel);
        JFrame f = new JFrame();
        f.setDefaultCloseOperation(WindowConstants.HIDE_ON_CLOSE);
        f.setContentPane(zoomsourcepanel);
        f.pack();
        f.setVisible(true);
    }

    public static void main(String[] args) {
        ZoomDemo demo = new ZoomDemo(Futil.getReadFile("select a gif image").toString());
        demo.setVisible(true);
    }
}
