//Enrique iturralde
//CR325
//March 28, 2005

package bookExamples.ch26Graphics.draw2d;


import gui.In;
import gui.run.RunButton;
import gui.run.RunSlider;
import gui.run.RunAffinePanel;

import javax.swing.*;
import java.awt.*;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.beans.PropertyEditor;

class Triangle2d extends DJShape
        implements PropertyEditor, Intersects, Movable {
    int x1 = 0;
    int y1 = 0;
    int diameter = 1;
    int radius = 1;
    Vec2d center = new Vec2d(0, 0);
    double radiusSq;
    private int yc = 0;
    private int xc = 0;


    Triangle2d(int _x1, int _y1, int _diameter) {
        super(_x1, _y1, _x1 + _diameter, _y1 + _diameter);
        x1 = _x1;
        y1 = _y1;
        diameter = _diameter;
        radius = diameter / 2;
        radiusSq = radius * radius;

    }

    public DJShape getInstance(int x1, int y1, int x2, int y2) {
        Triangle2d circle2d = new Triangle2d(x1, y1, x2, y2);
        return circle2d;
    }




    public Component getCustomEditor() {
        JPanel jp = new JPanel();
        jp.setLayout(new FlowLayout());
        jp.add(new JLabel("diameter"));
        jp.add(new RunSlider(RunSlider.HORIZONTAL, 10, 2000, diameter) {
            public void run() {
                diameter = getValue();
                pcs.firePropertyChange("Circle2d", Triangle2d.this, null);
            }
        });
        jp.add(new RunButton("setForeground") {
            public void run() {
                Triangle2d.this.setForeground(In.getColor());

                pcs.firePropertyChange("size", Triangle2d.this, null);
            }
        });
        jp.add(getRunAffinePanel());

        jp.setLayout(new FlowLayout());

        return jp;
    }



    public Triangle2d(int _x1, int _y1, int _x2, int _y2) {
        super(_x1, _y1, _x2, _y2);
       x1 = _x1;
        y1 = _y1;
        int dx = x1 - _x2;
        int dy = y1 - _y2;
        diameter = (int) Math.sqrt(dx * dx + dy * dy);
        if (_x1 > _x2) x1 = _x2;
        if (_y1 > _y2) y1 = _y2;
        radius = diameter / 2;
        radiusSq = radius * radius;
        center.v[0] = x1 + radius;
        center.v[1] = y1 + radius;
    }

    private void setCenter() {
        int radius = diameter / 2;
        center.v[0] = x1 + radius;
        center.v[1] = y1 + radius;
    }

    public Point getCenter() {
        return new Point((int) center.v[0], (int) center.v[1]);
    }

    public void draw(Graphics g) {
        //saveState(g);

        Point pc = getCenter();

        Graphics2D g2d = (Graphics2D) g;
        AffineTransform old = g2d.getTransform();
        AffineTransform affineTransform = getAffineTransform();
        g2d.transform(affineTransform);
        g2d.setColor(getForeground());
        int radius = diameter / 2;
        x1 = pc.x - radius;
        y1 = pc.y - radius;
        xc = (int) center.v[0];
        yc = (int) center.v[1];
        CircleFcn cf = new CircleFcn(xc, yc, radius);
        double v = (0.25 + 1 / 3.0);
        Point2D p1 = cf.getPoint(1 - v);
        Point2D p2 = cf.getPoint(1 - 0.25);
        Point2D p3 = cf.getPoint(1 - (v + 1 / 3.0));
        drawLine(p1, p2, g);
        drawLine(p2, p3, g);
        drawLine(p3, p1, g);
      //  g2d.drawOval(x1, y1, diameter, diameter);

       // g2d.fillOval(pc.x, pc.y, 2, 2);
        g2d.drawString("(" + pc.x + "," + pc.y + ")", pc.x + 3, pc.y + 3);
      //  g2d.drawLine(pc.x, pc.y, pc.x - radius, pc.y);
        g2d.setTransform(old);

    }

    public String toString() {
        Point pc = getCenter();
        return
                "xc,yc,r=" + pc.x + "," + pc.y + "," + diameter;
    }


    public boolean inside(Vec2d p) {

        Vec2d n = new Vec2d(p);
        n.sub(center);
        if (n.dot(n) > radiusSq)
            return false;
        else
            return true;
    }

    public Vec2d intersect(Ray2d ray) {

        double t, /* where the ray intersects */
                // vDotV = distance square from sphere center to
                // ray origin
                vDotV,
                dDotV,
                thc;        /* length sqare of the half chord */

        // vector to the center of the sphere from
        // ray origin
        Vec2d v = new Vec2d(center.v[0], center.v[1]);
        boolean inside = false;
        //System.out.println(ray);

        /* use the closest approach algorithm */
        // v = v - ray.p
        //System.out.println(v);
        v.sub(ray.p);
        // loc = v^2
        vDotV = v.dot(v);
        // Are we inside the circle?
        if (vDotV <= radiusSq)
            inside = true;

        // dDotV = D dot V =
        // cos(angle between ray and vec to center);
        dDotV = v.dot(ray.d);   /* find the closest approach */

        // object is behind the ray origin
        if ((inside != true) && (dDotV <= 0.0))
            return null;

        /* compute the half chord square from the ray intersection to the
           intersection normal. */
        thc = (dDotV * dDotV) - vDotV + radiusSq;
        if (thc < 0.0)
            return null;   /* ray misses the sphere */

        /* find the ray intersection */
        if (inside == true)
            t = dDotV + Math.sqrt(thc);
        else
            t = dDotV - Math.sqrt(thc);

        return ray.vecOnLine((double) t);
    }

    public void move(double x, double y) {
        center = new Vec2d(x, y);
    }

    public boolean isPaintable() {
        return false;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Object getValue() {
        return null;
    }

    public void setValue(Object value) {
    }

    public String getAsText() {
        return null;
    }

    public String getJavaInitializationString() {
        return null;
    }

    public String[] getTags() {
        return new String[0];
    }

    public void setAsText(String text) throws IllegalArgumentException {
    }

    public void paintValue(Graphics gfx, Rectangle box) {
    }
}
