package bookExamples.ch26Graphics.draw2d;

import java.awt.*;
import java.awt.geom.Point2D;
import java.awt.geom.Line2D;
import java.awt.geom.QuadCurve2D;

public class Rhombus2d extends DJShape {
    int h = 1;
    int w = 1;
    int xc = 0;
    int yc = 0;

    public DJShape getInstance(int x1, int y1, int x2, int y2) {
        return new Rhombus2d(x1, y1, x2, y2);
    }

    public int getX1() {
        return x1;
    }

    public int getY1() {
        return y1;
    }

    public int getW() {
        return w;
    }

    public int getH() {
        return h;
    }


    public Rhombus2d(int _x1, int _y1, int _x2, int _y2) {
        super(_x1, _y1, _x2, _y2);
        setX1(_x1);
        setY1(_y1);
        w = Math.abs(_x2 - x1);
        h = Math.abs(_y2 - y1);
        if (_x1 > _x2) setX1(_x2);
        if (_y1 > _y2) setY1(_y2);
        xc = x1 + w / 2;
        yc = y1 + h / 2;

    }
    public Point getCenter(){
        Polygon p = getPolygon();
        return getCenter(p);
    }

    private Point getCenter(Polygon p) {
        Rectangle r = p.getBounds();
        return new Point((int)r.getCenterX(),(int)r.getCenterY());
    }

    public void addPoint(Point2D p1, Polygon poly){
         poly.addPoint((int)p1.getX(),(int)p1.getY());
    }
    public Polygon getPolygon() {
        Polygon p = new Polygon();
        Point2D p1 = new Point2D.Float(x1+h, y1);
        Point2D p2 = new Point2D.Float(x1 + w+h, y1);
        Point2D p3 = new Point2D.Float(x1 + w, y1 + h);
        Point2D p4 = new Point2D.Float(x1, y1 + h);
        addPoint(p1,p);
        addPoint(p2,p);
        addPoint(p3,p);
        addPoint(p4,p);
        return p;
    }

    public void draw(Graphics g) {
        //saveState(g);

        Graphics2D g2d = (Graphics2D)g;
        Polygon polygon = getPolygon();
        g2d.draw(polygon);
        Point pc = getCenter(polygon);
        xc = (int)pc.getX();
        yc = (int)pc.getY();
        g.fillOval(xc, yc, 2, 2);
        g.drawString("(" + pc.getX() + "," + pc.getY() + ")",
                (int)pc.getX() + 3, (int)pc.getY() + 3);
        //restoreState(g);
    }
}
