package bookExamples.ch26Graphics.draw2d;


import javax.swing.*;
import java.awt.*;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;

public class Hexagon extends DJShape implements PropertyEditor {
    private String value = "Hexagon";
    private int radius;


    public Hexagon(int x1, int y1, int x2, int y2) {
        super(x1, y1, x2, y2);
        this.x1 = x1;
        this.y1 = y1;
        int dx = x1 - x2;
        int dy = y1 - y2;
        radius = (int) Math.sqrt(dx * dx + dy * dy);
    }

    public DJShape getInstance(int x1, int y1, int x2, int y2) {
        return new Hexagon(x1, y1, x2, y2);
    }

    public Point getCenter() {
        return new Point(x1, y1);
    }

    public void setValue(Object value) {
        this.value = (String) value;
    }

    public Object getValue() {
        return value;
    }

    public boolean isPaintable() {
        return false;
    }

    public void paintValue(Graphics gfx, Rectangle box) {
        gfx.setClip(box);
        gfx.drawString("Click to edit...", box.x + 5, box.y + 15);
    }

    public String getJavaInitializationString() {
        return null;
    }

    public String getAsText() {
        return null;
    }

    public void setAsText(String text) throws java.lang.IllegalArgumentException {
    }

    public String[] getTags() {
        return null;
    }

    public Component getCustomEditor() {

        JPanel jp = new JPanel(new FlowLayout());

        jp.add(getRunAffinePanel());

        return jp;
    }


    public boolean supportsCustomEditor() {
        return true;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        pcs.removePropertyChangeListener(listener);
    }


    private GeneralPath getGeneralPath() {
        CircleFcn circle = new CircleFcn(x1, y1, radius);
        double initialRotation = .75;
        GeneralPath gp = new GeneralPath();

        for (double t = 0; t < 1; t = t + 0.167) {
            Point2D point = circle.getPoint(t + initialRotation);
            if (t == 0) gp.moveTo((float) point.getX(), (float) point.getY());
            if (t > 0) gp.lineTo((float) point.getX(), (float) point.getY());
        }
        gp.closePath();

        return gp;
    }

    public void draw(Graphics g) {
        Graphics2D g2d = (Graphics2D) g;
        AffineTransform old = g2d.getTransform();
        AffineTransform affineTransform = getAffineTransform();
        g2d.transform(affineTransform);
        Color saveColor = g2d.getColor();
        g2d.setColor(getForeground());
        g2d.draw(getGeneralPath());
        g2d.fillOval(x1, y1, 2, 2);
        g2d.drawString("(" + x1 + ", " + y1 + ")", x1 + 3, y1 + 3);
        g2d.setTransform(old);
        g2d.setColor(saveColor);
        restoreState(g2d);
    }
}
