package bookExamples.ch26Graphics.draw2d;

import gui.ClosableJFrame;
import gui.In;
import gui.run.*;
import j2d.ImageUtils;

import javax.swing.*;
import java.awt.*;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.util.Vector;

//todo HW use the AffinePanel in the
// DJShape to alter the properties of your shape. /
// incorporate this into your custom property editor.
// use the Circle2D as your model for how to approach this homework.
// randeep  - ImageShape
// ed - SquareShape
// gino - Cone2d
// dave - PentagonShape
// keith - RightTriangleShape
// damian - HexagonShape
// ian - CylinderShape
// enrique - EquilateralShape
// todo Midterm - cr325    is due two weeks from 3/1/05
// 1. Debug your shape so that it works correctly.
//  a) it has a correct center point
/*
    b) we can set the color
    c) we can set the affine transform that is used to draw the shape.
        You should be able to: rotate, scale, shear and translate
    d) Rotations should be about the center point.
    e) You should be able to rotate the shape about any given point!
    f) eg. s.transform(affineTransformInstance);
    g) You dialog box should enable you to alter the properties of the affine
        transform that is used to alter the shape.
    h) Your CustomPropertyEditor can alter the properites of the shape...including:
        affineTransform, color.
    Hint; Use the AffineTransform class
    Implement the java.awt.Shape interface or add a
    GeneralPath  to your DJShape for drawing and support of these transforms.
*/

public class DrawComponent extends JComponent
        implements MouseListener, MouseMotionListener {
    private Font font = new Font("Times", Font.PLAIN, 12);

    private Shapes shapeList = new Shapes(0, 0, 0, 0);
    private int x1, y1;
    private Point p2 = new Point();
    private Point lastPoint = new Point();
    private DJShape lastSelectedDJShape = new Line2d(0, 0, 0, 0);
    private boolean addAShapeMode = true;
    private EditList editList = new EditList();

    public DrawComponent() {
        //todo check to see if this stops the update
        // problem we are having with drawing.
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        addMouseMotionListener(this);
        addMouseListener(this);
    }


    private void ray() {
        shapeList.addLineToLastCircle();
        repaint();
    }


    private void erase() {
        shapeList = new Shapes(0, 0, 0, 0);
        editList.erase();
        repaint();
    }


    private RunMenuBar getRunMenuBar() {
        RunMenuBar mb = new RunMenuBar();
        mb.add(getFileMenu());
        mb.add(getColorMenu());
        mb.add(getDrawMenu());
        return mb;
    }

    private void outputToPrinter() {
        ImageUtils.print(this);
    }

    private RunMenu getDrawMenu() {
        RunMenu drawMenu = new RunMenu("[Draw");
        drawMenu.add(new RunCheckBoxMenuItem("add shape", true) {
            public void run() {
                addAShapeMode = getState();
                if (!addAShapeMode)
                    setText("select a shape");
                else
                    setText("add shape");
            }
        });

        drawMenu.add(new RunMenuItem("sine wave{alt control N}") {
            public void run() {
                final SineFcn f = new SineFcn(100, 100, 100);
                final FunctionShape lastSelectedJShape
                        = new FunctionShape(x1, y1, p2.x, p2.y,
                                f, 0.01);
                //mediator(f);
                setLastSelectedShape(lastSelectedJShape);
            }
        });
         drawMenu.add(new RunMenuItem("hexagon") {
            public void run() {
                setLastSelectedShape(new Hexagon(x1, y1, p2.x, p2.y));
            }
        });
        drawMenu.add(new RunMenuItem("octagon") {
            public void run() {
                setLastSelectedShape(new Octagon(x1, y1, p2.x, p2.y));
            }
        });
        drawMenu.add(new RunMenuItem("s[piral{alt control P}") {
            public void run() {
                setLastSelectedShape(new Spiral(x1, y1, p2.x, p2.y));
            }
        });
        drawMenu.add(new RunMenuItem("le[ns{alt control L}") {
            public void run() {
                setLastSelectedShape(new Lens2d(x1, y1, p2.x, p2.y));
            }
        });

        drawMenu.add(new RunMenuItem("setRotationTo90") {
            public void run() {
                AffineTransform at = getLastSelectedShape()
                        .getAffineTransform();
                at.setToRotation(90 * Math.PI / 180, x1, y1);
                DrawComponent.this.repaint();
            }
        });
        drawMenu.add(new RunMenuItem("[erase{control E}") {
            public void run() {
                erase();
            }
        });
        drawMenu.add(new RunMenuItem("[line{control L}") {
            public void run() {
                setLastSelectedShape(new Line2d(0, 0, 0, 0));
            }
        });
        //
        drawMenu.add(new RunMenuItem("R[hombus2d{control H}") {
            public void run() {
                setLastSelectedShape(new Rhombus2d(x1, y1, p2.x, p2.y));
            }
        });
        drawMenu.add(new RunMenuItem("Pentagon[5{control 5}") {
            public void run() {
                setLastSelectedShape(new Pentagon(x1, y1, p2.x, p2.y));
            }
        });
        drawMenu.add(new RunMenuItem("Sq[uareShape2{control U}") {
            public void run() {
                setLastSelectedShape(new Square2d(x1, y1, p2.x, p2.y));
            }
        });
        drawMenu.add(new RunMenuItem("RtTrian[gle2d{alt T}") {
            public void run() {
                setLastSelectedShape(new RtTriangle2d(x1, y1, p2.x, p2.y));
            }
        });
        drawMenu.add(new RunMenuItem("C[ylinder{control Y}") {
            public void run() {
                setLastSelectedShape(new Cylinder(x1, y1, p2.x, p2.y));
            }
        });
        drawMenu.add(new RunMenuItem("C[one{control K}") {
            public void run() {
                setLastSelectedShape(new Cone2d(x1, y1, p2.x, p2.y));
            }
        });
        drawMenu.add(new RunMenuItem("[ImageShape{control I}") {
            public void run() {
                setLastSelectedShape(new ImageDJShape(x1, y1, p2.x, p2.y));
            }
        });
        drawMenu.add(new RunMenuItem("[triangle{control T}") {
            public void run() {
                setLastSelectedShape(new Triangle2d(0, 0, 0, 0));
            }
        });
        drawMenu.add(new RunMenuItem("[circle{control C}") {
            public void run() {
                setLastSelectedShape(new Circle2d(0, 0, 0, 0));
            }
        });
        drawMenu.add(new RunMenuItem("o[val{control O}") {
            public void run() {
                setLastSelectedShape(new Oval2d(0, 0, 0, 0));
            }
        });
        drawMenu.add(new RunMenuItem("[rect{control 6}") {
            public void run() {
                setLastSelectedShape(new Rect2d(0, 0, 0, 0));
            }
        });
        drawMenu.add(new RunMenuItem("[FillRect2d{control F}") {
            public void run() {
                setLastSelectedShape(new FillRect2d(0, 0, 0, 0));
            }
        });
        drawMenu.add(new RunMenuItem("[string{control s}") {
            public void run() {
                setLastSelectedShape(new String2d(p2.x, p2.y, "String me!"));
            }
        });
        drawMenu.add(new RunMenuItem("r[ay{control R}") {
            public void run() {
                ray();
            }
        });
        return drawMenu;
    }

    private JDialog displayPropertyEditor(PropertyEditor f) {
        if (!(f.supportsCustomEditor())) return null;
        f.addPropertyChangeListener(new PropertyChangeListener() {
            public void propertyChange(PropertyChangeEvent evt) {
                repaint();
            }
        });
        Component comp = f.getCustomEditor();
        JDialog jd = new JDialog();
        jd.setModal(false);
        Container c = jd.getContentPane();
        c.add(comp);

        jd.setSize(200, 100);
        jd.pack();
        jd.setVisible(true);
        return jd;
    }

    private RunMenu getColorMenu() {
        RunMenu colorMenu = new RunMenu("[Color");
        colorMenu.add(new RunMenuItem("set [background color{alt control c}") {
            public void run() {
                setBackgroundColor();
            }
        });
        colorMenu.add(new RunMenuItem("set [foreground color{alt control f}") {
            public void run() {
                setForegroundColor();
            }
        });

        return colorMenu;
    }

    private void setForegroundColor() {
        getParent().setForeground(In.getColor());
    }

    private void setBackgroundColor() {
        getParent().setBackground(In.getColor());
    }

    private RunMenu getFileMenu() {
        RunMenu fileMenu = new RunMenu("[File");

        fileMenu.add(new RunMenuItem("[print{control p}") {
            public void run() {
                outputToPrinter();
            }
        });

        fileMenu.add(new RunMenuItem("[quit{control q}") {
            public void run() {
                System.exit(0);
            }
        });


        return fileMenu;
    }


    public void mouseDragged(MouseEvent e) {
        e.consume();
        lastPoint.x = p2.x;
        lastPoint.y = p2.y;
        p2.x = e.getX();
        p2.y = e.getY();
        repaint();
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        e.consume();
        x1 = e.getX();
        y1 = e.getY();
        int x21 = -1;
        p2.x = x21;
        repaint();
    }

    public void mouseReleased(MouseEvent e) {
        if (!addAShapeMode) return;
        e.consume();
        int x2 = e.getX();
        int y2 = e.getY();
        DJShape lastSelectedShape = getLastSelectedShape();
        RunAffinePanel rap = lastSelectedShape.getRunAffinePanel();
        //this.removeMouseListener(rap);
        //this.removeMouseMotionListener(rap);
        DJShape djShape = lastSelectedShape.getInstance(x1, y1, x2, y2);
        rap = djShape.getRunAffinePanel();
        Point pc = djShape.getCenterPoint();
        rap.setCenterPoint(pc.x, pc.y);
        //addMouseMotionListener(rap);
        //addMouseListener(rap);
        shapeList.addShape(djShape);
        int xl1 = -1;
        lastPoint.x = xl1;
        int x21 = -1;
        p2.x = x21;
        repaint();
    }

    public void mouseEntered(MouseEvent e) {

    }

    public void mouseExited(MouseEvent e) {
        repaint();
    }

    public void mouseClicked(MouseEvent e) {
        if (!(e.getClickCount() == 2)) return;

        DJShape s = shapeList.getClosestShape(e.getPoint());
        Point pc = s.getCenterPoint();
        RunAffinePanel rap = s.getRunAffinePanel();
        rap.setCenterPoint(pc.x, pc.y);
        s.setSelected(true);
        if (!(s instanceof PropertyEditor)) {
            In.message("no prop editor for:" + s);
            return;
        }

        PropertyEditor propEd = (PropertyEditor) s;

        JDialog jd = displayPropertyEditor(propEd);
        if (jd != null) editList.push(s, jd);
        //System.out.println(s);
        repaint();
        e.consume();

    }

    class EditList {
        Vector v = new Vector();

        public void erase() {
            for (int i = 0; i < v.size(); i++) {
                ShapeDialog sd = (ShapeDialog) v.elementAt(i);

                sd.jd.setVisible(false);
            }
            v = new Vector();
        }

        class ShapeDialog {
            private JDialog jd;
            private DJShape s;

            ShapeDialog(DJShape s, JDialog jd) {
                this.s = s;
                this.jd = jd;
            }
        }

        public void remove(DJShape s) {
            for (int i = 0; i < v.size(); i++) {
                ShapeDialog sd = (ShapeDialog) v.elementAt(i);
                if (sd.s.equals(s)) {
                    sd.jd.setVisible(false);
                }

            }
        }

        public void push(DJShape s, JDialog jd) {
            v.addElement(new ShapeDialog(s, jd));
        }
    }

    public void drawRubberBand(Graphics g) {
        if (!addAShapeMode) return;
        if (p2.x == -1) return;
        g.setXORMode(getBackground());
        DJShape lastSelectedShape = getLastSelectedShape();
        RunAffinePanel rapOld = lastSelectedShape.getRunAffinePanel();
        //removeMouseListener(rapOld);
        //removeMouseMotionListener(rapOld);
        DJShape shapeInstance = lastSelectedShape.getInstance(x1, y1, p2.x, p2.y);
        RunAffinePanel rap = shapeInstance.getRunAffinePanel();
        //addMouseListener(rap);
        //addMouseMotionListener(rap);
        shapeInstance.draw(g);
    }

    public void paintComponent(Graphics g) {

        super.paintComponent(g);
        g.setFont(font);
        shapeList.draw(g);
        drawRubberBand(g);

    }


    public static void main(String args[]) {
        DrawComponent drawComponent = new DrawComponent();
        ClosableJFrame cf = new ClosableJFrame("DocJavaDraw");
        cf.setJMenuBar(drawComponent.getRunMenuBar());
        Container c = cf.getContentPane();
        c.setLayout(new BorderLayout());
        c.add(drawComponent, BorderLayout.CENTER);
        cf.setSize(300, 300);
        cf.setVisible(true);
    }


    public DJShape getLastSelectedShape() {
        return lastSelectedDJShape;
    }

    public void setLastSelectedShape(DJShape lastSelectedDJShape) {
        this.lastSelectedDJShape = lastSelectedDJShape;

        repaint();
    }
}













