package bookExamples.ch26Graphics.draw2d;

/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */

import gui.In;
import gui.run.RunSlider;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;

public class Cylinder extends DJShape implements
        PropertyEditor {
    int h = 1;
    int w = 1;
    int xc = 0;
    int yc = 0;
    int cf = 0;

    int customRotate_x = 0;
    int customRotate_y = 0;
    static int customRotate_flag = 0;

    public PropertyChangeSupport pcs = new PropertyChangeSupport(this);


    public DJShape getInstance(int x1, int y1, int x2, int y2) {
        Cylinder cyl = new Cylinder(x1, y1, x2, y2);
        cyl.setForeground(getForeground());
        //cyl.setAffineTransform(getAffineTransform());
        return cyl;

    }

    public int getX() {
        return x1;
    }

    public int getY() {
        return y1;
    }

    public int getW() {
        return w;
    }

    public int getH() {
        return h;
    }


    public Cylinder(int _x1, int _y1, int _x2, int _y2) {
        super(_x1, _y1, _x2, _y2);
        setX1(_x1);
        setY1(_y1);
        w = Math.abs(_x2 - x1);
        h = Math.abs(_y2 - y1);
        if (_x1 > _x2) setX1(_x2);
        if (_y1 > _y2) setY1(_y2);
        xc = x1 + w / 2;
        yc = y1 + h / 2;
        cf = h / 8;
        y2 = y1 + h;

    }

    public Point getCenter() {
        return new Point(xc, yc);
    }

    int centroid [] = {w / 2, w / 2};

    Polygon p5 = new Polygon();

    //Mat3 at;

    Graphics tempg;

    int theta = 0;
    double shear_x = 0.0;
    double shear_y = 0.0;
    double tx = 0.0;
    double ty = 0.0;
    AffineTransform at = new AffineTransform();

    public void draw(Graphics g) {


       // Graphics2D g2d = (Graphics2D) g;
      //  g2d.setTransform(at);


      //  g2d.setColor(getForeground());

        Graphics2D g2d = (Graphics2D) g;
        AffineTransform old = g2d.getTransform();
        AffineTransform affineTransform = getAffineTransform();
        g2d.transform(affineTransform);
        g2d.setColor(getForeground());

        g2d.drawLine(x1, y1, x1, y2);
        g2d.drawLine(x1 + w, y1, x1 + w, y2);

        g2d.drawOval(x1, y1 - cf, w, h / 4);
        g2d.drawOval(x1, y2 - cf, w, h / 4);

        g2d.fillOval(xc, yc, 2, 2);
        g2d.drawString("(" + xc + "," + yc + ")", xc + 3, yc + 3);
        g2d.setTransform(old);

    }


    //Method to support Custom Editing
    public Point2D getPoint(double t) {

        return new Point2D.Double();
    }

    //Test Method to view CODE analysis
    public boolean isPaintable() {
        System.out.println("In boolean Method");
        return false;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public void update() {

        pcs.firePropertyChange("Cylinder", this, null);
    }


    public JButton colorButton;
    public JButton customRotate;

    public java.awt.Component getCustomEditor() {

        JPanel jp = new JPanel();


        colorButton = new JButton("Color");
        colorButton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent event) {
                System.out.println("In Color");
                Cylinder.this.setForeground(In.getColor());
                Cylinder.this.update();
            }
        });
        jp.add(colorButton);


        jp.add(getRunAffinePanel());

        jp.setLayout(new FlowLayout());


        jp.setVisible(true);
        return jp;
    }





    public Object getValue() {
        return null;
    }


    public void setValue(Object value) {
    }


    public String getAsText() {
        return null;
    }


    public String getJavaInitializationString() {
        return null;
    }


    public String[] getTags() {
        return new String[0];
    }


    public void setAsText(String text) throws IllegalArgumentException {
    }

   
    public void paintValue(Graphics gfx, Rectangle box) {
    }


}


