package bookExamples.ch26Graphics.draw2d;

public class Coords {
    public static int[] translateCoords(int startX, int startY, int endX, int endY) {
    /** Translates input coords to top-left, bottom-right */
        return new int[] {Math.min(startX, endX), Math.min(startY, endY)
            , Math.abs(startX - endX), Math.abs(startY - endY)};
    }

    public static int[] scaleCoords(int srcW, int srcH, int destW, int destH) {
    /*** Scales srcW, -H destW, -H, maintaining aspect ratio */
        int w, h;
        boolean wbias = srcW > srcH ? true : false;

        if (wbias) {
            w = destW;
            h = destW * srcH/srcW;
        } else {
            w = destH * srcW/srcH;
            h = destH;
        }

        return new int[] {(destW-w)/2, (destH-h)/2, w, h};
    }
}
