package bookExamples.ch18Swing;

import gui.In;
import gui.run.RunButton;
import gui.In;

import javax.swing.*;
import javax.swing.event.ChangeListener;
import javax.swing.event.ChangeEvent;
import javax.swing.colorchooser.ColorSelectionModel;
import java.awt.*;

/**
 * DocJava, Inc.
 * http://www.docjava.com
 * Programmer: dlyon
 * Date: Sep 22, 2004
 * Time: 8:16:02 PM
 */
public class AtomicExamples {
    public static void main(String[] args) {
        progressBarExample();
    }

    private static void progressBarExample() {
        // for homework, use the JColorChooser to
        // alter the foreground color of the JProgressBar.
        // in the ch18 package.
        final JColorChooser jcc = new JColorChooser();
        final JProgressBar jp = new JProgressBar();
        final JLabel jl = new JLabel("% done=" + 0);
        jp.setMinimum(0);
        jp.setMaximum(100);
        JDialog jd = new JDialog();
        Container c = jd.getContentPane();
        c.add(new RunButton("setForeground") {
            public void run() {
                jp.setForeground(jcc.getColor());
            }
        });
        final ColorSelectionModel csm = jcc.getSelectionModel();
        csm.addChangeListener(new ChangeListener() {
            public void stateChanged(ChangeEvent ce) {
                jl.setForeground(csm.getSelectedColor());
            }
        });
        c.add(new RunButton("setBackground") {
            public void run() {
                jp.setBackground(jcc.getColor());
            }
        });
        c.add(jp);
        c.add(jl);
        c.add(jcc);
        c.setLayout(new FlowLayout());
        jd.pack();
        jd.show();
        for (int i = 0; i <= 100; i++) {
            jp.setValue(i);
            jl.setText("% done=" + i);
            try {
                Thread.sleep(500);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private static void ex1() {
        String name = In.getString("what is your name?");
        int age = In.getInt("enter an age between 6 and 110", 6, 110);
        In.message("Hello " + name + " you are " + age + " old!");
    }
}
