package bookExamples.ch14Files;

import futils.DirList;
import futils.Futil;
import futils.WildFilter;
import gui.In;

import java.io.File;

/**
 * DocJava, Inc.
 * http://www.docjava.com
 * Programmer: dlyon
 * Date: Oct 18, 2004
 * Time: 2:44:21 PM
 */
public class FileExamples {
    public static void main(String[] args) {
       Futil.testGetReadFiles();
    }

    /**
     * list all the files in a given directory and its subdirectories.
     */
    private static void getSubdirectoryExample() {
        String suffix = In.getString("enter a suffix for a file list");
        String prefix = In.getString("enter a prefix for a file list");
        String midfix = In.getString("enter a midfix for a file list");
        WildFilter fnf = new WildFilter(prefix, midfix, suffix);
        DirList d = new DirList(Futil.getDir("select start"),fnf);
        File f[] = d.getFiles();
        if (f == null || f.length == 0) {
            In.message("no files found with ");
            return;
        }
        File aFile = (File)
                In.multiPrompt(f, "select a file", "file selection dialog");
        In.message("you select:" + aFile);
        
    }

    public static void getFileExample() {
        String suffix = In.getString("enter a suffix for a file list");
        WildFilter fnf = new WildFilter(suffix);
        File dir = Futil.getReadDirFileJTree("select a directory containing files that end with "
                + suffix);
        File f[] = dir.listFiles(fnf);
        if (f == null || f.length == 0) {
            In.message("no files found with " + suffix + " suffix.");
            return;
        }
        File aFile = (File)
                In.multiPrompt(f, "select a file", "file selection dialog");
        In.message("you select:" + aFile);
    }

    public static void getDirExample() {
        In.message("welcome to my file examples!");
        File f = futils.Futil.getReadDirFileJTree("select a directory");
        In.message("you selected:" + f.getAbsolutePath());
    }
}
