/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package addbk.JAddressBook;

import gui.ClosableJFrame;
import gui.In;
import gui.run.*;

import javax.swing.*;
import java.awt.*;
import java.util.Observer;
import java.util.Observable;

public abstract class ViewPanel
        extends JPanel implements Runnable, Observer {

    private AddressRecord ar = new AddressRecord();
    private AddressDataBase adb =
            AddressDataBase.getAddressBookDatabase();
    private RunTextField nameTextField = new RunTextField(20) {
        public void run() {
            ar.setName(getText());
        }
    };
    private RunTextArea addressTextArea =
            new RunTextArea(10, 20) {
                public void run() {
                    ar.setAddress(getText());
                }
            };
    private RunTextArea notesTextArea =
            new RunTextArea(10, 20) {
                public void run() {
                    ar.setInfo(getText());
                }
            };
    private RunTextField dialTextField1 =
            new RunTextField(ar.getDial1()) {
                public void run() {
                    ar.setDial1(getText());
                }
            };
    private RunTextField dialTextField2 =
            new RunTextField(ar.getDial2()) {
                public void run() {
                    ar.setDial2(getText());
                }
            };
    private RunTextField dialTextField3 =
            new RunTextField(ar.getDial3()) {
                public void run() {
                    ar.setDial3(getText());
                }
            };

    public ViewPanel() {
        setLayout(new BorderLayout());
        nameTextField.setText(ar.getName());
        nameTextField.setEditable(false);
        add(nameTextField, BorderLayout.NORTH);
        add(getAddressNotesPanel(), BorderLayout.CENTER);
        add(getSouthPanel(), BorderLayout.SOUTH);
        adb.addObserver(this);
    }
    public RunMenuBar getRunMenuBar() {
        RunMenuBar rmb = new RunMenuBar();

        rmb.add(getFileMenu());
        rmb.add(getEditMenu());
        rmb.add(getHelpMenu());
        return rmb;
    }
    public void update(Observable observable, Object obj){
        setValue(adb.getCurrentRecord());
    }
    private RunMenu getHelpMenu(){
        RunMenu rm = new RunMenu("[Help");
        rm.add(new RunMenuItem("testHelp") {
            public void run() {
                Help h = new Help();
                h.display();
            };
        });
        return rm;
    }
    private RunMenu getEditMenu() {
        RunMenu rm =
                new RunMenu("[Edit");
        rm.add(new RunMenuItem("[New{control n}") {
            public void run() {
                newRecordFrame();
            };
        });
        rm.add(new RunMenuItem("[Edit Record{control e}") {
            public void run() {
                editRecordFrame();
            };
        });
        rm.add(new RunMenuItem("[Find{control f}") {
            public void run() {
                showFindFrame();
            };
        });

        return rm;
    }

    private void editRecordFrame() {
        final ClosableJFrame cf = new ClosableJFrame();
        EditPanel co = getEditPanel(cf);
        co.setValue(ar);
        cf.addComponent(co);
        cf.setSize(400, 400);
        cf.setVisible(true);
    }


    private void newRecordFrame() {
        final ClosableJFrame cf = new ClosableJFrame();
        cf.addComponent(new NewRecordPanel(){
            public void run(){
                cf.setVisible(false);
            }
        });
        cf.setSize(400, 400);
        cf.setVisible(true);
    }
    private EditPanel getEditPanel(final ClosableJFrame cf) {
        EditPanel co = new EditPanel() {
            public void run() {
                cf.setVisible(false);
                ViewPanel.this.setValue(getValue());
            }
        };
        return co;
    }

    public void showFindFrame() {
        ClosableJFrame cf = new ClosableJFrame();
        Container c = cf.getContentPane();
        c.add(new RunFindPanel() {
            public void run() {
                find(getFindBean());
            }
        });
        cf.setSize(250, 150);
        cf.setVisible(true);
    }

    private void find(FindBean findBean) {
        AddressRecord ar = adb.find(findBean);
        if (ar == null){
            In.message("address not found");
            return;
        }
        setValue(ar);

    }


    private RunMenu getFileMenu() {
        RunMenu fileMenu =
                new RunMenu("[File");
        fileMenu.add(new RunMenuItem("[quit{control q}") {
            public void run() {
                System.exit(0);
            };
        });
        return fileMenu;
    }


    public void setValue(AddressRecord ar) {
        this.ar = ar;
        nameTextField.setText(ar.getName());
        addressTextArea.setText(ar.getAddress());
        notesTextArea.setText(ar.getInfo());
        dialTextField1.setText(ar.getDial1());
        dialTextField2.setText(ar.getDial2());
        dialTextField3.setText(ar.getDial3());
    }



    public JPanel getSouthPanel() {
        JPanel jp = new JPanel();
        jp.setLayout(new BorderLayout());
        jp.add(getPhoneNumberPanel(), BorderLayout.CENTER);
        jp.add(getNavigationPanel(), BorderLayout.EAST);
        jp.add(getDialPanel(), BorderLayout.WEST);
        return jp;
    }

    public JPanel getNavigationPanel() {
        JPanel jp = new JPanel();
        jp.setLayout(new GridLayout(0, 1));
        jp.add(
                new RunButton("[Previous") {
                    public void run() {
                        ViewPanel.this.setValue(
                                adb.getPreviousRecord());
                    }
                });
        jp.add(
                new RunButton("[Next") {
                    public void run() {
                        ViewPanel.this.setValue(
                                adb.getNextRecord());
                    }
                });
        jp.add(
                new RunButton("[Index") {
                    public void run() {
                        RunIndexPanel.setIndexFrameVisible(true);
                    }
                });
        return jp;
    }
    public JPanel getDialPanel() {
        JPanel jp = new JPanel();
        jp.setLayout(new GridLayout(0, 1));
        jp.add(new RunButton("Dial[1") {
            public void run() {

            }
        });
        jp.add(new RunButton("Dial[2") {
            public void run() {

            }
        });
        jp.add(new RunButton("Dial[3") {
            public void run() {

            }
        });
        return jp;
    }


    public JPanel getPhoneNumberPanel() {
        JPanel jp = new JPanel();

        jp.setLayout(new GridLayout(0, 1));
        dialTextField1.setEditable(false);
        dialTextField2.setEditable(false);
        dialTextField3.setEditable(false);
        dialTextField1.setBorder(BorderFactory.createEtchedBorder());
        dialTextField2.setBorder(BorderFactory.createEtchedBorder());
        dialTextField3.setBorder(BorderFactory.createEtchedBorder());
        jp.add(dialTextField1);
        jp.add(dialTextField2);
        jp.add(dialTextField3);
        return jp;
    }

    public JPanel getAddressNotesPanel() {
        JPanel jp = new JPanel();
        addressTextArea.setText(ar.getAddress());
        notesTextArea.setText(ar.getInfo());
        addressTextArea.setEditable(false);
        notesTextArea.setEditable(false);
        jp.setLayout(new GridLayout(0, 1));
        addressTextArea.setBorder(BorderFactory.createEtchedBorder());
        notesTextArea.setBorder(BorderFactory.createEtchedBorder());
        jp.add(addressTextArea);
        jp.add(notesTextArea);
        return jp;
    }

    public AddressRecord getValue() {
        ar.setName(nameTextField.getText());
        ar.setAddress(addressTextArea.getText());
        ar.setInfo(notesTextArea.getText());
        ar.setDial1(dialTextField1.getText());
        ar.setDial2(dialTextField2.getText());
        ar.setDial3(dialTextField3.getText());
        return ar;
    }

    public static void main(String[] args) {
        ClosableJFrame cf = new ClosableJFrame();
        ViewPanel vp = new ViewPanel() {
                            public void run() {
                                System.out.println(getValue());
                            }
                        };
        cf.setJMenuBar(vp.getRunMenuBar());
        cf.addComponent(vp);
        cf.setSize(400, 400);
        cf.setVisible(true);
    }
}
