/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package addbk.JAddressBook;

import gui.ClosableJFrame;
import gui.layouts.VerticalFlowLayout;
import gui.run.*;

import javax.swing.*;
import java.awt.*;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Observer;
import java.util.Observable;

/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: Apr 10, 2005
 * <p/>
 * Time: 6:30:24 AM
 */
public class RunIndexPanel extends JPanel
        implements Runnable,Observer {
    private AddressDataBase adb = AddressDataBase.getAddressBookDatabase();
    private RunLabelRecord rl[] =
            new RunLabelRecord[getNumberOfRows()];

    public RunIndexPanel() {
        setLayout(new BorderLayout());
        add(getLabelPanel(), BorderLayout.CENTER);
        add(getButtonControlPanel(), BorderLayout.SOUTH);
        add(getLetterPanel(), BorderLayout.EAST);
        adb.addObserver(this);
    }

    private int getNumberOfRows() {
        return 19*3; //19 rowsx3columns
    }
    public void update(Observable obs, Object obj){
        updateLabels();
    }

    AddressRecord getValue() {
        return adb.getCurrentRecord();
    }


    ViewPanel vp = new ViewPanel() {
        public void run() {

        }
    };
    ClosableJFrame viewFrame = getViewFrame();


    private JPanel getButtonControlPanel() {
        JPanel jp = new JPanel();

        jp.setLayout(new FlowLayout());
        jp.add(
                new RunButton("find") {
                    public void run() {
                        adb.top();
                        viewFrame.setVisible(true);
                        vp.showFindFrame();
                    }
                });
        jp.add(
                new RunButton("prev") {
                    public void run() {
                      adb.previous(getNumberOfRows());
                    }
                });
        jp.add(
                new RunButton("next") {
                    public void run() {
                        adb.next(getNumberOfRows());
                    }
                });
        jp.add(
                new RunButton("edit") {
                    public void run() {
                        editRecord();
                    }
                });
        return jp;
    }

    private JPanel getLetterPanel() {
        JPanel jp = new JPanel() {
            public Dimension getPreferredSize() {
                return new Dimension(20, 100);
            }

            public Dimension getMinimumSize() {
                return getPreferredSize();
            }
        };
        jp.setLayout(new GridLayout(0, 1));
        for (int j = 0; j < 26; j++)
            jp.add(
                    new RunLabel("  " + (char) (('a' + j)) + "") {
                        public void run() {
                            adb.findLetter(getText());
                        }
                    });
        return jp;
    }

    public static String getShortName(AddressRecord ar) {
        String s = ar.getName();
        if (s.length() < 20) return s;
        return s.substring(0, 20);
    }

    class RunLabelRecord extends RunLabel {
        AddressRecord ar;

        RunLabelRecord(AddressRecord ar) {
            super(getShortName(ar));
            this.ar = ar;
        }


        public AddressRecord getValue() {
            return ar;
        }

        public void setValue(AddressRecord ar) {
            this.ar = ar;
            setText(getShortName(ar));
        }
    }

    private void updateLabels() {
        AddressRecord ar[] = adb.getNextRecords(getNumberOfRows());
        for (int i = 0; i < ar.length; i++)
            rl[i].setValue(ar[i]);
        updateBorders(adb.getCurrentRecord());
    }


    private void setValue(AddressRecord value) {
        adb.findRecordAndSetToCurrent(value);
        updateBorders(value);
    }

    private void updateBorders(AddressRecord value) {
        for (int j = 0; j < getNumberOfRows(); j++) {
            RunLabelRecord rlr = rl[j];
            if (rlr.getValue() == value)
                rlr.setBorder(BorderFactory.createEtchedBorder());
            else
                rlr.setBorder(BorderFactory.createEmptyBorder());
        }
    }


    private JPanel getLabelPanel() {
        JPanel jp = new JPanel();

        jp.setLayout(new VerticalFlowLayout(0, 5));
        for (int j = 0; j < getNumberOfRows(); j++) {
            final RunLabelRecord runLabel =
                    new RunLabelRecord(adb.getNextRecord()) {
                        public void run() {
                            RunIndexPanel.this.setValue(getValue());
                        }
                    };
            runLabel.addMouseListener(
                    new MouseAdapter() {
                        public void mouseClicked(MouseEvent e) {
                            if (e.getClickCount() == 2)
                                view(runLabel);
                        }
                    });
            rl[j] = runLabel;
            jp.add(runLabel);
        }
        return jp;
    }

    public void view(RunLabelRecord rld) {
        vp.setValue(rld.getValue());
        viewFrame.setVisible(true);
    }

    private ClosableJFrame getViewFrame() {
        ClosableJFrame viewFrame = new ClosableJFrame();
        viewFrame.setJMenuBar(vp.getRunMenuBar());
        viewFrame.addComponent(vp);
        viewFrame.setSize(400, 400);
        return viewFrame;
    }

    public RunMenuBar getRunMenuBar() {
        RunMenuBar rmb = new RunMenuBar();

        rmb.add(getFileMenu());
        rmb.add(getEditMenu());
        return rmb;
    }

    private RunMenu getEditMenu() {
        RunMenu editMenu =
                new RunMenu("[Edit");
        editMenu.add(
                new RunMenuItem("[New{control n}") {
                    public void run() {
                        newRecord();
                    };
                });
        editMenu.add(
                new RunMenuItem("[Edit Record{control e}") {
                    public void run() {
                        editRecord();
                    };
                });
        editMenu.add(
                new RunMenuItem("[Find{control f}") {
                    public void run() {
                        vp.showFindFrame();
                    };
                });
        return editMenu;
    }

    private void newRecord() {
        final ClosableJFrame cf = new ClosableJFrame();
        NewRecordPanel co = new NewRecordPanel() {
            public void run() {
                cf.setVisible(false);
                vp.setValue(getValue());
            }
        };
        cf.addComponent(co);
        cf.setSize(400, 400);
        cf.setVisible(true);
    }

    private RunMenu getFileMenu() {
        RunMenu fileMenu =
                new RunMenu("[File");
        fileMenu.add(
                new RunMenuItem("[open gzipped db") {
                    public void run() {
                        adb.openGzippedDb();
                        updateLabels();
                    };
                });
        fileMenu.add(
                new RunMenuItem("[save gzipped db") {
                    public void run() {
                        adb.saveGzippedDb();
                    };
                });

        fileMenu.add(new MergeMenu());
        fileMenu.add(new ExportMenu());


        fileMenu.add(
                new RunMenuItem("Scan 4 ct Lawyers") {
                    public void run() {
                        AddressUrlUtils.scanForLawyers();
                        adb.sort();
                        updateLabels();
                    };
                });

        fileMenu.add(
                new RunMenuItem("[quit{control q}") {
                    public void run() {
                        System.exit(0);
                    };
                });
        return fileMenu;
    }


    private void editRecord() {
        final ClosableJFrame cf = new ClosableJFrame();
        EditPanel co = new EditPanel() {
            public void run() {
                cf.setVisible(false);
                vp.setValue(getValue());
                RunIndexPanel.this.updateLabels();
            }
        };
        co.setValue(adb.getCurrentRecord());
        cf.addComponent(co);
        cf.setSize(400, 400);
        cf.setVisible(true);
    }

    public void run() {
        updateLabels();
    }

    public static void main(String[] args) {
        showRunIndexFrame();

    }

    private static final ClosableJFrame indexFrame = new ClosableJFrame();

    public static void setIndexFrameVisible(boolean b) {
        indexFrame.setVisible(b);

    }

    private static void showRunIndexFrame() {

        RunIndexPanel rip = new RunIndexPanel();

        indexFrame.setJMenuBar(rip.getRunMenuBar());
        indexFrame.addComponent(rip);
        indexFrame.setSize(400, 400);
        indexFrame.setVisible(true);
    }
}
