/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package addbk.JAddressBook;

import gui.ClosableJFrame;
import gui.run.RunButton;
import gui.run.RunTextArea;
import gui.run.RunTextField;

import javax.swing.*;
import javax.swing.border.TitledBorder;
import java.awt.*;

public abstract class NewRecordPanel
        extends JPanel implements Runnable {

    private AddressRecord ar = new AddressRecord();
    private AddressDataBase abdb =
            AddressDataBase.getAddressBookDatabase();
    private RunTextField nameTextField = new RunTextField(20) {
        public void run() {
            ar.setName(getText());
        }
    };
    private RunTextArea addressTextArea = getAddressTextArea();
    private RunTextArea infoTextArea = getInfoTextArea();

    private RunTextField dialTextField1 =
            new RunTextField(ar.getDial1()) {
                public void run() {
                    ar.setDial1(getText());
                }
            };
    private RunTextField dialTextField2 =
            new RunTextField(ar.getDial2()) {
                public void run() {
                    ar.setDial2(getText());
                }
            };
    private RunTextField dialTextField3 =
            new RunTextField(ar.getDial3()) {
                public void run() {
                    ar.setDial3(getText());
                }
            };

    private RunTextArea getInfoTextArea() {
        RunTextArea ta = new RunTextArea(10, 20) {
            public void run() {
                ar.setInfo(getText());
            }
        };
        String label = "notes";
        TitledBorder titledBorder = BorderFactory.createTitledBorder(label);
        ta.setBorder(titledBorder);
        ta.setToolTipText(label);
        ta.setFocusAccelerator('\t');
        ta.setLineWrap(true);
        return ta;
    }

    public void setValue(AddressRecord ar) {
        this.ar = ar;
        nameTextField.setText(ar.getName());
        addressTextArea.setText(ar.getAddress());
        infoTextArea.setText(ar.getInfo());
        dialTextField1.setText(ar.getDial1());
        dialTextField2.setText(ar.getDial2());
        dialTextField3.setText(ar.getDial3());
    }
    private RunTextArea getAddressTextArea() {
        RunTextArea ta = new RunTextArea(10, 20) {
            public void run() {
                ar.setAddress(getText());
            }
        };
        String label = "address";
        TitledBorder titledBorder = BorderFactory.createTitledBorder(label);
        ta.setBorder(titledBorder);
        ta.setToolTipText(label);
        ta.setFocusAccelerator('\t');
        ta.setLineWrap(true);
        return ta;
    }

    public NewRecordPanel() {
        setLayout(new BorderLayout());
        nameTextField.setText(ar.getName());
        add(nameTextField, BorderLayout.NORTH);
        add(getAddressNotesPanel(), BorderLayout.CENTER);
        add(getSouthPanel(), BorderLayout.SOUTH);
    }

    public JPanel getSouthPanel() {
        JPanel jp = new JPanel();
        jp.setLayout(new BorderLayout());
        jp.add(getPhoneNumberPanel(), BorderLayout.CENTER);
        jp.add(getButtonControlPanel(), BorderLayout.EAST);
        return jp;
    }

    public JPanel getButtonControlPanel() {
        JPanel jp = new JPanel();
        jp.setLayout(new GridLayout(0, 1));
        jp.add(
                new RunButton("[Next") {
                    public void run() {
                        abdb.addRecord(getValue());
                        NewRecordPanel.this.setValue(
                                new AddressRecord());
                    }
                });
        jp.add(
                new RunButton("[Done") {
                    public void run() {
                        abdb.addRecord(getValue());
                        NewRecordPanel.this.run();
                    }
                });
        jp.add(
                new RunButton("[Cancel") {
                    public void run() {
                        NewRecordPanel.this.run();
                    }
                });
        return jp;
    }


    public JPanel getPhoneNumberPanel() {
        JPanel jp = new JPanel();

        jp.setLayout(new GridLayout(0, 1));
        dialTextField1.setBorder(BorderFactory.createEtchedBorder());
        dialTextField2.setBorder(BorderFactory.createEtchedBorder());
        dialTextField3.setBorder(BorderFactory.createEtchedBorder());
        jp.add(dialTextField1);
        jp.add(dialTextField2);
        jp.add(dialTextField3);
        return jp;
    }

    public JPanel getAddressNotesPanel() {
        JPanel jp = new JPanel();
        addressTextArea.setText(ar.getAddress());
        infoTextArea.setText(ar.getInfo());
        jp.setLayout(new GridLayout(0, 1));
        jp.add(addressTextArea);
        jp.add(infoTextArea);
        return jp;
    }

    public AddressRecord getValue() {
        ar.setName(nameTextField.getText());
        ar.setAddress(addressTextArea.getText());
        ar.setInfo(infoTextArea.getText());
        ar.setDial1(dialTextField1.getText());
        ar.setDial2(dialTextField2.getText());
        ar.setDial3(dialTextField3.getText());
        return ar;
    }

    public static void main(String[] args) {
        showEditFrame();
    }
    public static void showEditFrame(AddressRecord ar) {
        ClosableJFrame cf = new ClosableJFrame();
        NewRecordPanel co = new NewRecordPanel() {
                    public void run() {
                        System.out.println(getValue());
                    }
                };
        co.setValue(ar);
        cf.addComponent(co);
        cf.setSize(400, 400);
        cf.setVisible(true);
    }
    public static void showEditFrame() {
        ClosableJFrame cf = new ClosableJFrame();
        cf.addComponent(
                new NewRecordPanel() {
                    public void run() {
                        System.out.println(getValue());
                    }
                });
        cf.setSize(400, 400);
        cf.setVisible(true);
    }
}
