package addbk.JAddressBook;

import gui.run.DelimiterBean;
import gui.ClosableJFrame;

import javax.swing.*;
import java.awt.*;

/**
 * JTableExample uses a custom TableModel.
 */
public class JTableExample {
    private final JPanel jp = new JPanel(new GridLayout(1, 0));
    private static final int WIDTH = 500;
    private static final int HEIGHT = 70;

    /**
     * A program to illustrate the use of the JTable
     */
    public JTableExample() {
        String[] columnNames = {
            "Name",
            "Addrss",
            "info",
            "phone1",
            "phone2",
            "phone3"
        };

        Object[][] data = getRecords(getRecordsFromAddressDataBase(100));
        final TableData dm = new TableData(columnNames, data);
        JTable table = new JTable(dm.getTableModel());
        table.setPreferredScrollableViewportSize(
                new Dimension(WIDTH, HEIGHT));
        jp.add(new JScrollPane(table));
    }

    private AddressRecord[] getRecordsFromAddressDataBase(int n) {
        AddressDataBase adb = AddressDataBase.getAddressBookDatabase();

        adb.mergeUsingDelimiters(DelimiterBean.restore());
        AddressRecord ara[] = new AddressRecord[n];
        for (int i = 0; i < n; i++)
            ara[i] = adb.getNextRecord();
        return ara;
    }

    private Object[][] getRecords(AddressRecord ar[]) {
        Object o[][] = new Object[ar.length][5];
        for (int i = 0; i < ar.length; i++)
            o[i] = getRecord(ar, i);
        return o;
    }

    private Object[] getRecord(AddressRecord ar[], int i) {
        return new Object[]{
            ar[i].getName(),
            ar[i].getAddress(),
            ar[i].getInfo(),
            ar[i].getDial1(),
            ar[i].getDial2(),
            ar[i].getDial3()
        };
    }


    private static void initGui() {
        ClosableJFrame frame = new ClosableJFrame();
        initContentPane(frame);
        frame.pack();
        frame.setVisible(true);
    }

    private static void initContentPane(JFrame frame) {
        JTableExample newContentPane = new JTableExample();
        //must paint every pixel in component bounds:
        newContentPane.jp.setOpaque(true);
        frame.setContentPane(newContentPane.jp);
    }



    public static void main(String[] args) {
        initGui();
    }
}
