/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package addbk.JAddressBook;

import gui.ClosableJFrame;
import gui.run.DelimiterBean;
import gui.run.RunDelimiterPanel;
import gui.run.RunMenu;
import gui.run.RunMenuItem;

import java.awt.*;

/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: Apr 22, 2005
 * <p/>
 * Time: 7:06:35 AM
 */
// This runnable panel invokes the run method when the user
// is done.
public class ExportMenu extends RunMenu   {
    DelimiterBean delimiterBean = DelimiterBean.restore();
    public ExportMenu(){
        super("[Export");
        add(new RunMenuItem("set delimiters..."){
            public void run(){
                showDelimiterFrame();
            }
        });
        add(new RunMenuItem("export using delimiters..."){
            public void run(){
                exportUsingDelimiters();
            }
        });
        add(new RunMenuItem("export xml...") {
            public void run() {
                exportXml();
            }
        });
    }

    private void exportXml() {
        AddressDataBase adb = AddressDataBase.getAddressBookDatabase();
        adb.saveAsXml();
    }

    private void exportUsingDelimiters(){
        AddressDataBase adb = AddressDataBase.getAddressBookDatabase();
        adb.exportCsv(delimiterBean);
    }
    private void showDelimiterFrame() {
        final ClosableJFrame cf = new ClosableJFrame("Delimiter Frame");
        Container c = cf.getContentPane();
        c.add(new RunDelimiterPanel() {
            public void run() {
                delimiterBean = getDelimiterBean();
                cf.setVisible(false);
            }
        });
        cf.pack();
        cf.setVisible(true);
    }
}
