package addbk.JAddressBook;

import utils.StringUtils;
import xml.Utils;

import java.beans.XMLEncoder;
import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.util.StringTokenizer;

public class AddressRecord
        implements Serializable, Comparable {
    private String name = "";
    private String address = "";
    private String info = "";
    private String dial1 = "";
    private String dial2 = "";
    private String dial3 = "";

    private static String recordDelimiter = ",";//"~";
    private static String newLineDelimiter = "\t";

    public int compareTo(Object o) {
        AddressRecord that = (AddressRecord) o;
        return this.name.compareTo(that.name);
    }

    public static AddressRecord getRecord(
            String line) {

        AddressRecord abr =
                new AddressRecord();

        StringTokenizer st = new StringTokenizer(
                line, recordDelimiter);
        try {
            abr.name = st.nextToken();

            abr.address = filterString(st);
            abr.info = filterString(st);
            abr.dial1 = st.nextToken();
            abr.dial2 = st.nextToken();
            abr.dial3 = st.nextToken();
        } catch (Exception e) {
        }
        ;

        return (abr);
    }
    /**
     * If a record has new lines in it, they can be delimited
     * with the new-line delimiter.
     * @param st
     * @return
     */
    private static String filterString(StringTokenizer st) {
        return StringUtils.replaceAll(st.nextToken(),newLineDelimiter,"\n");
    }

    public String toString(){
        return Utils.getXmlString(this);
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getInfo() {
        return info;
    }

    public void setInfo(String info) {
        this.info = info;
    }

    public String getDial1() {
        return dial1;
    }

    public void setDial1(String dial1) {
        this.dial1 = dial1;
    }

    public String getDial2() {
        return dial2;
    }

    public void setDial2(String dial2) {
        this.dial2 = dial2;
    }

    public String getDial3() {
        return dial3;
    }

    public void setDial3(String dial3) {
        this.dial3 = dial3;
    }
    public String toXml() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        XMLEncoder e = new XMLEncoder(baos);
        e.writeObject(this);
        e.flush();
        return baos.toString();
    }
    public static AddressRecord getEmptyDbRecord() {
        AddressRecord abr =
                new AddressRecord();
        abr.setName("--- Empty Database ---");
        abr.setAddress("Use the <File> menu to\n <Open> a database object,\n <Merge> a CSV file");
        abr.setInfo("Or use the [EDIT] button to\n [Add Record]s to the empty DB");
        abr.setDial1("");
        abr.setDial2("");
        abr.setDial3("");
        return (abr);
    }

    public String[][] getRecordAsArray() {
        return new String[][] {
            {name, address, info, dial1, dial2, dial3}  

        };

    }
}
