package addbk.JAddressBook;

import futils.Futil;
import futils.ReaderUtil;
import futils.WriterUtil;
import gui.In;
import gui.run.DelimiterBean;
import gui.run.FindBean;
import utils.CompactJava;
import utils.StringUtils;
import xml.Utils;

import java.awt.*;
import java.io.*;
import java.util.Collections;
import java.util.Observable;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;


public final class AddressDataBase extends Observable {
    private Vector addressVector = new Vector();
    private int recordNumber = 0;

    private static AddressDataBase adb = new AddressDataBase();

    public static AddressDataBase getAddressBookDatabase() {
        return adb;
    }

    private AddressDataBase() {
        addRecord(new AddressRecord());
    }

    public void update() {
        setChanged();
        notifyObservers();
    }

    public void mergeUsingDelimiters(DelimiterBean db) {
        File f = Futil.getReadFile("select a text file to merge");
        if (f == null) return;
        String s = ReaderUtil.getFileAsOneBigString(f);
        StringTokenizer st = new StringTokenizer(
                s, db.getRecordDelimiter());
        while (st.hasMoreTokens())
            addRecord(st.nextToken(), db);

        sort();
        top();
        In.message("done with merge");
    }

    /**
     * Add s, assuming it contains one records and is parsed using db.
     *
     * @param s  string with record
     * @param db has field and line delimiters
     */
    public void addRecord(String s, DelimiterBean db) {
        s = StringUtils.replaceAll(s, db.getLineDelimiter(), "\n");
        StringTokenizer st = new StringTokenizer(
                s, db.getFieldDelimiter());
        AddressRecord ar = new AddressRecord();
        try {
            ar.setName(st.nextToken());
            ar.setAddress(st.nextToken());
            ar.setInfo(st.nextToken());
            ar.setDial1(st.nextToken());
            ar.setDial2(st.nextToken());
            ar.setDial3(st.nextToken());

        } catch (Exception e) {
            addRecord(ar);
        }
    }

    public void saveAsXml() {
        File f = Futil.getWriteFile("Select xml file for output");
        WriterUtil.writeString(f, toString());
    }

    public String toString() {
        return CompactJava.toXml(addressVector)
                + "</java>";
    }

    public void sort() {
        Collections.sort(addressVector);
        update();
    }

    public AddressRecord readRecord() {
        return (AddressRecord) addressVector.elementAt(recordNumber);
    }

    public AddressRecord readRecord(int recNumber) {
        return (AddressRecord) addressVector.elementAt(recNumber);
    }


    public void addRecord(AddressRecord abr) {
        addressVector.addElement(abr);
        recordNumber = addressVector.size() - 1;
        update();
    }

    public void deleteRecord(AddressRecord abr) {
        addressVector.removeElement(abr);
    }

    /**
     * @return size of the currently held database
     */
    public int getSize() {
        return addressVector.size();
    }

    public void deleteCurrentRecord() {
        addressVector.removeElementAt(recordNumber);
    }

    public void openGzippedDb() {
        try {
            readDbObject(); 	// gzip format
            //readFromFile();	// object w/o gzip
        } catch (IOException e) {
            System.out.println("IOException");
        } catch (ClassNotFoundException e) {
            System.out.println("ClassNotFoundException");
        }
        top();
    }

    public void saveGzippedDb() {
        try {
            System.out.println("Saving Address Db Object");
            saveDbObject();		// gzip format
            //writeToFile();	// object w/o gzip
        } catch (IOException e) {
            System.out.println("IOERROR: " + e.getMessage());
        }
    }

    public void readDbObject() throws IOException
            , ClassNotFoundException {
        String readFileName = Futil.getReadFileName("Select input file");
        if (readFileName == null) return; //user canceled
        FileInputStream fis
                = new FileInputStream(readFileName);
        GZIPInputStream gis
                = new GZIPInputStream(fis);
        ObjectInputStream ois
                = new ObjectInputStream(gis);
        addressVector = (Vector) ois.readObject();
        ois.close();
        gis.close();
        fis.close();
        top();
    }// readObject


    public void saveDbObject() throws IOException {
        FileOutputStream fos
                = new FileOutputStream(
                        Futil.getWriteFile("Select output file"));
        GZIPOutputStream gos
                = new GZIPOutputStream(fos);
        ObjectOutputStream oos
                = new ObjectOutputStream(gos);
        oos.writeObject(addressVector);
        System.out.println("working with save...");
        oos.flush();
        oos.close();
        gos.finish();
        fos.close();

    }


    public AddressRecord getCurrentRecord() {
        if (recordNumber >= addressVector.size()) top();
        return (AddressRecord)
                addressVector.elementAt(recordNumber);
    }

    public static void beep() {
        final Toolkit tk = Toolkit.getDefaultToolkit();
        tk.beep();
    }

    public AddressRecord getPreviousRecord() {
        if (recordNumber == 0) {
            beep();
            return getCurrentRecord();
        }
        recordNumber--;
        update();
        return getCurrentRecord();
    }

    public AddressRecord getNextRecord() {
        if (recordNumber == addressVector.size() - 1) {
            beep();
            return getCurrentRecord();
        }
        recordNumber++;
        update();
        return getCurrentRecord();
    }

    public void exportCsv(DelimiterBean db) {
        String rd = db.getRecordDelimiter();

        try {
            BufferedWriter bw = WriterUtil.getBufferedWriter(
                    "select a text file for export");
            if (bw == null) return;
            for (int i = 0; i <
                    (getSize()); i++) {
                AddressRecord abr = readRecord(i);
                bw.write(filterRecord(abr.getName(), db));
                bw.write(filterRecord(abr.getAddress(), db));
                bw.write(filterRecord(abr.getInfo(), db));
                bw.write(filterRecord(abr.getDial1(), db));
                bw.write(filterRecord(abr.getDial2(), db));
                bw.write(filterRecord(abr.getDial3(), db));
                bw.write(rd);
            }
            bw.close();
        } catch (FileNotFoundException e) {
        } catch (IOException e) {
        }
    }

    private String filterRecord(String name, DelimiterBean db) {
        return StringUtils.replaceAll(
                name,
                "\n",
                db.getLineDelimiter()) +
                db.getFieldDelimiter();
    }

    private AddressRecord findHelperFunction(int i, AddressRecord ar) {
        recordNumber = i;
        update();
        return ar;
    }

    private boolean isContainedBy(String s1, String s2) {
        s1 = s1.toLowerCase();
        s2 = s2.toLowerCase();
        if (s1.indexOf(s2) != -1) return true;
        return false;
    }

    /**
     * Use the findBean to locate an address record. Return it if you find
     * it, otherwise return null. Set the recordNumber, if you find the
     * record, otherwise leave it alone.
     */
    public AddressRecord find(FindBean findBean) {
        String s = findBean.getFindString();
        for (int i = recordNumber + 1; i < addressVector.size(); i++) {
            AddressRecord ar = (AddressRecord) addressVector.elementAt(i);
            if (findBean.isInName() && isContainedBy(ar.getName(), s))
                return findHelperFunction(i, ar);
            if (findBean.isInAddress() &&
                    isContainedBy(ar.getAddress(), s))
                return findHelperFunction(i, ar);
            if (findBean.isInInfo() && isContainedBy(ar.getInfo(), s))
                return findHelperFunction(i, ar);
            if (findBean.isInPhone() && isContainedBy(ar.getDial1(), s))
                return findHelperFunction(i, ar);
            if (findBean.isInPhone() && isContainedBy(ar.getDial2(), s))
                return ar;
            if (findBean.isInPhone() && isContainedBy(ar.getDial3(), s))
                return findHelperFunction(i, ar);

        }
        return null;
    }

    public void top() {
        if (recordNumber == 0) return;
        recordNumber = 0;
        update();
    }

    public void replaceCurrentRecord(AddressRecord ar) {
        addressVector.setElementAt(ar, recordNumber);
        update();
    }

    public void findRecordAndSetToCurrent(AddressRecord value) {
        for (int i = 0; i < addressVector.size(); i++) {
            AddressRecord ar = (AddressRecord) addressVector.elementAt(i);
            if (ar.equals(value)) {
                recordNumber = i;
                update();
                return;
            }
        }
        System.out.println("could not find record");

    }

    public Vector getAddressVector() {
        return addressVector;
    }

    public void setAddressVector(Vector addressVector) {
        this.addressVector = addressVector;
    }

    public int getRecordNumber() {
        return recordNumber;
    }

    public void setRecordNumber(int recordNumber) {
        this.recordNumber = recordNumber;
    }

    //todo debug this method
    public void mergeXml() {
        File f = Futil.getReadFile("select an xml file");
        String fileAsOneBigString = ReaderUtil.getFileAsOneBigString(f);
        mergeXml(fileAsOneBigString);
    }

    public void mergeXml(String xmlString) {
        if (xmlString == null) return;
        Vector v = (Vector) Utils.decodeXml(xmlString);
        System.out.println(v.size() + "=size");
        for (int i = 0; i < v.size(); i++) {
            addRecord((AddressRecord) v.elementAt(i));
        }
        sort();
        update();
    }

    public void print() {
        for (int i = 0; i < addressVector.size(); i++) {
            System.out.println(addressVector.elementAt(i));
        }
    }

    public static void main(String[] args) {

        adb.addRecord(AddressRecord.getEmptyDbRecord());
        adb.mergeXml();
        adb.print();
    }

    /**
     * getN records from addressbook. Do not notify observers.
     */
    public AddressRecord[] getNextRecords(int n) {

        AddressRecord ar[] = new AddressRecord[n];
        for (int i = 0; i < n; i++) {
            ar[i] = new AddressRecord();

        }
        for (int i = 0; i < n; i++) {
            int j = i + recordNumber;
            if (j < addressVector.size())
                ar[i] = (AddressRecord) addressVector.elementAt(j);
            else break;
        }

        return ar;
    }
    /**
     * Search the database until you find the letter
     * or the letter just previous to it.
     * @param text
     */
    public void findLetter(String text) {
        text = text.toUpperCase().trim();
        for (int i=0; i < addressVector.size(); i++){
            AddressRecord ar = (AddressRecord)addressVector.elementAt(i);
            String name = ar.getName().toUpperCase().trim();
            if (name.startsWith(text)){
                recordNumber = i;
                update();
                return;
            }
        }
        searchForChar(text.toCharArray()[0]);
    }

    private void searchForChar(int c) {
        if (c==0){
              top();
            return;
        }
        for (int i = 0; i < addressVector.size(); i++) {
            AddressRecord ar = (AddressRecord) addressVector.elementAt(i);
            String name = ar.getName().toUpperCase().trim();
            char[] chars = name.toCharArray();
            if (chars.length == 0) continue;
            if (chars[0]==c) {
                recordNumber = i;
                update();
            }
        }
        searchForChar(c-1);
    }

    public void previous(int numberOfRows) {
        recordNumber = recordNumber - numberOfRows;
        if (recordNumber < 0) recordNumber = 0;
        update();
    }
    public void next(int numberOfRows) {
        recordNumber = recordNumber + numberOfRows-1;
        if (recordNumber >= addressVector.size())
            recordNumber = addressVector.size() - numberOfRows;
        if (recordNumber < 0) recordNumber = 0;
        update();
    }
}


