package xml.adbk;

import futils.CsvParser;
import futils.ReaderUtil;
import futils.SerialUtils;
import futils.WriterUtil;
import gui.html.HtmlSynthesizer;

import java.io.*;
import java.util.Collections;
import java.util.Vector;
import java.beans.XMLEncoder;

/**
 * xml.AddressBook is responsible for holding
 * Address instances and converting them to XML or
 * CSV format.
 */
//todo: make sortable.

public class AddressBook
        implements Serializable {
    private transient int recordNumber = 0;
    private Vector addressVector = new Vector();
    public Vector getAddressVector(){
        return addressVector;
    }
    public void setAddressVector(Vector addressVector) {
          this.addressVector=addressVector;
    }

    public void addAddress(Address a) {
        addressVector.addElement(a);
    }

    public void sort() {
        System.out.println("sorting");
        //***** Un comment on JDK 1.2 or better to sort
        Collections.sort(addressVector);
    }

    public void deleteRecord(Address abr) {
        addressVector.removeElement(abr);
    }

    public String getAddressXml() {
        StringBuffer sb = new StringBuffer("\n");
        for (int i = 0; i < addressVector.size(); i++)
            sb.append(((Address) addressVector.elementAt(i)).toXml());
        return sb.toString();
    }


    public String toXml() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        XMLEncoder e = new XMLEncoder(baos);
        e.writeObject(this);
        e.flush();
        return baos.toString();
    }

    public String toHtmlTable() {
        HtmlSynthesizer hs =
                new HtmlSynthesizer();
        String aa[] = new String[addressVector.size()];
        for (int i = 0; i < addressVector.size(); i++) {
            aa[i] =
            ((Address) addressVector.elementAt(i)).toHtml();
        }
        return hs.getTable(hs.getSheet(aa));
    }

    public String toHtmlCsv() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < addressVector.size(); i++) {
            sb.append(
                    ((Address) addressVector.elementAt(i)).toCsv() +
                    "<p>");
        }
        return sb.toString();
    }

    public String toCsv() {
        String s = "\n";
        for (int i = 0; i < addressVector.size(); i++)
            s =
            s +
            ((Address) addressVector.elementAt(i)).toCsv();
        return s;
    }

    public String toString() {
        return toXml();
    }

    public void processLine(String l) {
        String[] tokens = new CsvParser(l).getTokens();
        addressVector.addElement(new Address(tokens));
    }

    /**
     * getAddress from another addressBook and add
     * them to your vector!
     */
    public void merge(AddressBook ab) {
        Address aa[] = ab.getAddresses();
        for (int i = 0; i < aa.length; i++)
            addAddress(aa[i]);
    }

    public Address[] getAddresses() {
        Address aa[] = new Address[addressVector.size()];
        addressVector.copyInto(aa);
        return aa;
    }

    public void getLines(BufferedReader br) {
        try {
            for (String l = br.readLine(); l !=
                                           null; l =
                                                 br.readLine())
                processLine(l);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void open(BufferedReader br)
            throws IOException {
        getLines(br);
        br.close();
    }

    public void open() {
        try {
            open(
                    ReaderUtil.getBufferedReader(
                            "select *.csv"));
        } catch (IOException e) {
        }
    }

    public void openXmlGz() {
        try {
            String s = SerialUtils.readGzipString();
            System.out.println("Read in:" + s);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void saveXmlGz() {
        try {
            SerialUtils.writeGzipString(toXml());
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void save() {
        BufferedWriter bw =
                WriterUtil.getBufferedWriter(
                        "output xml");
        WriterUtil.println(bw, toXml());
        WriterUtil.close(bw);
    }

    public void saveAsCsv() {
        BufferedWriter bw =
                WriterUtil.getBufferedWriter(
                        "output xml");
        WriterUtil.println(bw, toCsv());
        WriterUtil.close(bw);
    }

    public void saveAsXml() {
        BufferedWriter bw =
                WriterUtil.getBufferedWriter(
                        "output xml");
        WriterUtil.println(bw, toXml());
        WriterUtil.close(bw);
    }

    public void saveAsXml(File f) {
        BufferedWriter bw =
                WriterUtil.getBufferedWriter(f);
        WriterUtil.println(bw, toXml());
        WriterUtil.close(bw);
    }

    public AddressBook search(
            String searchString) {
        Address a;
        AddressBook ab = new AddressBook();
        for (int i = 0; i < addressVector.size(); i++) {
            a = (Address) addressVector.elementAt(i);
            if (a.match(searchString))
                ab.addAddress(a);
        }
        return ab;
    }

    public int getNumRecords() {
        return (addressVector.size());
    }

    public void deleteCurrentRecord() {
        addressVector.removeElementAt(recordNumber);
    }

    public Address getPreviousAddress() {
        decrementRecord();
        return (Address) addressVector.elementAt(
                recordNumber);
    }

    public Address getNextAddress() {
        incrementRecord();
        return (Address) addressVector.elementAt(
                recordNumber);
    }

    public void incrementRecord() {
        if (recordNumber < (addressVector.size() - 1))
            recordNumber++;
    }

    public void decrementRecord() {
        if (recordNumber > 0)
            recordNumber--;
    }
    public void printLastNames() {
        for (int i=0 ; i < addressVector.size(); i++){
          Address a = (Address)  addressVector.elementAt(i);
            System.out.println("lastName="+a.getLastName());
        }
    }

    public void setRecordNumber(int index) {
        if ((index >= 0) && (index <= addressVector.size()))
            recordNumber = index;
        System.out.println(recordNumber);
    }

    public static void main(String args[]) {
        Address a = new Address();
        a.setLastName("fee");
        a.setFirstName("foo");
        a.setCompany("Vectron");
        a.setHomePage("http://www.vectron.com");
        AddressBook ab = new AddressBook();
        ab.addAddress(a);


        System.out.println(ab.toXml());

        //System.out.println("ab=" + ab.toXml());
        //ab.saveXmlGz();
        ab.openXmlGz();
    }

}
