package video.jsnap;

import gui.In;
import gui.dialogs.ProgressDialog;
import ip.gif.neuquantAnimation.AnimatedGifEncoder;
import j2d.ImageUtils;
import sound.Oscillator;

import java.awt.*;
import java.awt.image.BufferedImage;
import java.util.Vector;

/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: Nov 26, 2004
 * <p/>
 * Time: 9:05:43 AM
 */
public class OneFrameAtATimeCapture {

    public static void neuquantImageStreamToAFile(NeuquantCaptureBean ncb)
            throws AWTException {
        Robot robot = new Robot();
        Dimension outputDim = ncb.getOutputSize();
        AnimatedGifEncoder age = new AnimatedGifEncoder();

        if (ncb.isLooped()) age.setRepeat(0);
        age.setDelay((int) ncb.getSecondsPerFrame() * 1000);
        age.setTransparent(Color.BLACK);
        age.start(ncb.getOutputFile());

        Vector imageBufferVector = new Vector();

        int frameNumber = 1;
        do {
            grabNextFrame(robot,
                            ncb,
                            outputDim,
                            imageBufferVector,
                            age);
            frameNumber++;

        } while (In.getBoolean("ready for frame#" +
                frameNumber +
                "?"));
        if (ncb.isBuffered()) {
            compressBufferedImages(imageBufferVector, age);
        }
        age.finish();
    }

    private static void grabNextFrame(Robot robot,
                                     NeuquantCaptureBean ncb,
                                     Dimension outputDim,
                                     Vector imageBufferVector,
                                     AnimatedGifEncoder age) {
        BufferedImage bi = grabImage(robot, ncb, outputDim);

        if (ncb.isBuffered())
            imageBufferVector.addElement(bi);
        else
            addImageToEncoder(age, bi);

        playTone(ncb);
    }

    private static BufferedImage grabImage(Robot robot,
                                                 NeuquantCaptureBean ncb,
                                                 Dimension outputDim) {
        BufferedImage bi =
                grabScreen(robot, ncb.getInputRectangle());
        if (outputDim.equals(ncb.getInputRectangle().getSize())){
            return bi; // no need to scale
        }
        bi = ImageUtils.scaleSmooth(bi,
                outputDim.width,
                outputDim.height);
        return bi;
    }

    private static void compressBufferedImages(Vector v,
                                               AnimatedGifEncoder age) {
        ProgressDialog pd = ProgressDialog.getInstance();
        pd.setTitle("saving images...");
        pd.setVisible(true);
        final int n = v.size();
        for (int i = 0; i < n; i++) {
            pd.setAmountDone(i * 100 / n);
            addImageToEncoder(age, (BufferedImage) v.elementAt(i));
        }
        pd.setVisible(false);
    }

    private static void playTone(NeuquantCaptureBean ncb) {
        if (ncb.isSilentOnCapture()) return;
        Oscillator.beep();
    }


    private static void addImageToEncoder(AnimatedGifEncoder age,
                                          BufferedImage bi) {
        if (age.addFrame(bi) == false)
            In.message("problem adding image");
    }

    public static BufferedImage grabScreen(Robot robot, Rectangle rect) {
        return robot.createScreenCapture(rect);
    }

    /**
     * @param d the number of seconds to sleep.
     */
    public static void sleep(long d) {
        try {
            Thread.sleep(d);
        } catch (InterruptedException e) {
            e.printStackTrace();

        }

    }
}
