/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package utils;

import futils.DirList;

import java.io.File;
import java.io.FileFilter;

/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: Mar 6, 2005
 * <p/>
 * Time: 10:07:45 AM
 */
public class ResourceManager {
    private static File userDir = new File(utils.SystemUtils.getUserDir());
    private static File dataDir = new File(getUserDir(),"data");
    private static File dataDir3d = new File(getDataDir(),"3d");
    private static File audioDir = new File(getDataDir(), "audio");
    private static File imageDir = new File(
            getDataDir(),
            "images"+
            SystemUtils.getDirectorySeparator());
    private static DirList imageDirectoryList =  new DirList(imageDir,
            new FileFilter(){
                public boolean accept(File file){
                    return file.isFile();
                }

    });
    private static DirList dir3dDirectoryList = new DirList(dataDir3d,
            new FileFilter() {
                public boolean accept(File file) {
                    return file.isFile();
                }

            });
    private static DirList audioDirList = new DirList(audioDir,
            new FileFilter() {
                public boolean accept(File file) {
                    return file.isFile();
                }

            });


    public static File getAudioFile(String fn){
        return audioDirList.findFile(fn);
    }

    public static File get3dFile(String fn){
        return dir3dDirectoryList.findFile(fn);
    }

    public static File getImageFile(String fn) {
        return imageDirectoryList.findFile(fn);
    }

    public static File getImageFile(File f){
        return getImageFile(f.getName());
    }

    public static File getDataDir3d(){
        return dataDir3d;
    }
    public static File getImageDir(){
        return imageDir;
    }

    public static File getUserDir() {
        return userDir;
    }

    public static File getDataDir() {
        return dataDir;
    }
}
