/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package utils;

/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: Mar 9, 2005
 * <p/>
 * Time: 9:18:09 AM
 */
import java.io.IOException;
import java.net.URL;
import java.net.MalformedURLException;
import java.lang.reflect.InvocationTargetException;

/**
 * Runs a jar application from any url. Usage is 'java JarRunner url
 * [args..]' where url is the url of the jar file and args is optional
 * arguments to be passed to the application's main method.
 */
public class JarRunner {
    public static void resourceTester() {
         // http://show.docjava.com:8086/book/cgij/code/20050309Data.jar
        // can we get resources out of a large jar?
    }
    public static void main(String[] args) {
        String[] newArgs = {};
        URL url = null;
        try {
            url = new URL("http://show.docjava.com:8086/book/cgij/code/jnlp/dhry.Main.jar");
        } catch (MalformedURLException e) {
            fatal("Invalid URL: " + args[0]);
        }
        // Create the class loader for the application jar file
        JarClassLoader cl = new JarClassLoader(url);
        // Get the application's main class name
        String name = null;
        try {
            name = cl.getMainClassName();
        } catch (IOException e) {
            System.err.println("I/O error while loading JAR file:");
            e.printStackTrace();
            System.exit(1);
        }
        if (name == null) {
            fatal("Specified jar file does not contain a 'Main-Class'" +
                    " manifest attribute");
        }
        // Get arguments for the application


        // Invoke application's main class
        try {
            cl.invokeClass(name, newArgs);
        } catch (ClassNotFoundException e) {
            fatal("Class not found: " + name);
        } catch (NoSuchMethodException e) {
            fatal("Class does not define a 'main' method: " + name);
        } catch (InvocationTargetException e) {
            e.getTargetException().printStackTrace();
            System.exit(1);
        }
    }

    private static void fatal(String s) {
        System.err.println(s);
        System.exit(1);
    }

}

