package utils;

import futils.Futil;
import gui.In;
import gui.JInfoFrame;
import xml.adbk.Address;

import java.beans.XMLEncoder;
import java.io.*;

/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: Dec 27, 2004
 * <p/>
 * Time: 7:52:01 AM
 */
public class CompactJava {
    private static JInfoFrame jif = new JInfoFrame();
    public static void main(String[] args) {
        jif.setSize(300, 300);
        jif.show();
        final String c1 = "a whole directory at once";
        final String c2 = "one file at a time";
        String choices[] ={
            c1 ,
            c2
        };
        String c =
                (String)In.multiPrompt(
                        choices,
                        "do you want to do ",
                        "CompactJava dialog");
        try {
            if (c.equals(c1))
                compactDirectory();
            else {
                compactFile();

            }
        } catch (IOException e) {
            In.message(e);
        }
        In.message("paste above into a java program, " +
                "use Utils.Base64 for decode");
    }

    private static void compactFile() throws IOException {
        do {
            File f = Futil.getReadFile("select resource");
            if (f == null) return;
            jif.println(getCompactJava(f, f.getName()));

        } while (In.getBoolean("go again?"));
    }

    private static void compactDirectory() throws IOException {
        printCompactJavas();
        In.message("paste above into a java program");
    }

    public static void printCompactJavas() throws IOException {
        File f = Futil.getReadDirFileJTree("select a resource directory");
        if (f == null) return;
        File fa[] = f.listFiles(new FileFilter() {

            public boolean accept(File pathname) {
                return pathname.isFile();
            }
        });
        for (int i = 0; i < fa.length; i++)
            jif.println(getCompactJava(fa[i], fa[i].getName()));

    }

    public static void testGetJava() {
        Serializable s = Address.getSample();
        jif.println(getJava(s));
    }

    public static String getUnqualifiedClassName(Object o) {
        String s = o.getClass().getName();
        int i = s.lastIndexOf('.');
        if (i == -1) return s;
        return s.substring(i + 1);
    }

    public static String getCompactJava() {
        File f = Futil.getReadFile("select a resource file");
        return getCompactJava(f);
    }

    public static String getCompactJava(File f, String variableName)
            throws IOException {
        FileInputStream fis = new FileInputStream(f);
        int n = fis.available();
        byte b[] = new byte[n];
        fis.read(b);
        fis.close();
        return getCompactJava(b, variableName);
    }

    /**
     * Input a serializable object and get back a very long string that is
     * a base64 encoded gzipped version of the serialized object suitable
     * for compilation into a Java program.
     *
     * @param object
     * @return
     */
    public static String getCompactJava(Serializable object) {
        String instanceName = getUnqualifiedClassName(object)
                + object.hashCode();
        String s = "static String " +
                instanceName +
                "=\n\"" +
                Base64.encodeObject(object,
                        Base64.GZIP | Base64.DONT_BREAK_LINES)
                + "\";";
        return s;
    }

    public static String getJavaVariable(String s) {

        s = StringUtils.replaceAll(s, ".", "Dot");
        s = StringUtils.replaceAll(s, "-", "Dash");
        return s;
    }

    public static String getCompactJava(Serializable object,
                                        String variableName) {
        String javaName = getJavaVariable(variableName);
        String s =
                "  String " +
                javaName +
                "Name" +
                "=\"" +
                variableName +
                "\";\n" +
                "  String " +
                javaName +
                "=\n\"" +
                Base64.encodeObject(object,
                        Base64.GZIP | Base64.DONT_BREAK_LINES)
                +
                "\";\n" +
                "Object o = Base64.decodeToObject(" +
                javaName +
                ");\n";

        return s;
    }

    public static String getJava(Serializable object) {
        String instanceName = getUnqualifiedClassName(object)
                + object.hashCode();
        String s = toXml(object);
        s = s + "</java>";
        s = StringUtils.replaceAllSb(s, "\"", "\\\"");
        s = StringUtils.replaceAllSb(s, "\n", "\"+\n\"");
        StringBuffer sb = new StringBuffer(s);
        sb.insert(0, "private static String " + instanceName + " =\"");
        sb.append("\";");
        return sb.toString();
    }

    public static String toXml(Serializable object) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        XMLEncoder e = new XMLEncoder(baos);
        e.writeObject(object);
        e.flush();
        return baos.toString();
    }
}
