package thread;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

abstract class RunButton extends Button
        implements Runnable, ActionListener {
    RunButton(String label) {
        super(label);
        addActionListener(this);
    }

    Thread t = null;

    public void actionPerformed(ActionEvent e) {
        t = new Thread(this);
        t.start();
    }
}

/**
 *   example of one button interrupting another button.
 */
public class ThreadusInterruptus extends Frame {
    static RunButton cancelButton = new RunButton("cancel") {
        public void run() {
            try {
                Thread.sleep(2000);
                System.out.println("cancel!");
            } catch (InterruptedException ie) {
                System.out.println("I canceled my cancel!");
            }
        }
    };


    public static void main(String args[]) {
        Frame f = new Frame();
        f.setSize(200, 200);
        f.setLayout(new FlowLayout());
        f.add(new RunButton("ok") {
            public void run() {
                cancelButton.t.interrupt();
                System.out.println("dsfoirsojkgrnior");
            }
        });
        f.add(cancelButton);
        f.show();
    }
}

