package sound.player;

/**
 * Created by IntelliJ IDEA.
 * User: Douglas Lyon
 * Date: Dec 13, 2004
 * Time: 8:56:46 PM
 * Copyright DocJava, Inc.
 */
public class LiveSoundEvent {

    /**
     * Construct a LiveSoundEvent, with the specified parameter.
     *
     * @param parameter The audio parameter of LiveSound that
     *                  has changed. The value of parameter should be one of
     *                  LiveSoundEvent.SAMPLE_RATE, LiveSoundEvent.CHANNELS,
     *                  LiveSoundEvent.BUFFER_SIZE, or
     *                  LiveSoundEvent.BITS_PER_SAMPLE.
     */
    public LiveSoundEvent(int parameter) {
        // FIXME: Should check that the value is parameter is legal.
        _parameter = parameter;
    }

    ///////////////////////////////////////////////////////////////////
    ////                         public methods                    ////

    /**
     * Return the parameter of LiveSound that has changed. The
     * corresponding method of LiveSound may then be invoked do
     * discover the new value of the parameter. For example, if
     * a sample rate change occurs, then this method will return
     * LiveSoundEvent.SAMPLE_RATE. The getSampleRate() method of
     * LiveSound may then be invoked to discover the new value
     * of the sample rate.
     *
     * @return SAMPLE_RATE, CHANNELS, BUFFER_SIZE, or BITS_PER_SAMPLE.
     */
    public int getSoundParameter() {
        return _parameter;
    }

    ///////////////////////////////////////////////////////////////////
    ////                         public members                    ////

    /**
     * The value indicates a sample rate change event.
     */
    public static final int SAMPLE_RATE = 0;

    /**
     * The value indicates a channel number change event.
     */
    public static final int CHANNELS = 1;

    /**
     * The value indicates a buffer size change event.
     */
    public static final int BUFFER_SIZE = 2;

    /**
     * The value indicates a bits per channel change event.
     */
    public static final int BITS_PER_SAMPLE = 3;

    ///////////////////////////////////////////////////////////////////
    ////                       private fields                    ////

    private int _parameter;
}