/**
 * Role of the Key map is to
 * map a QWERTY keyboard into a musical
 * keyboard.
 * Input is a KeyChar
 * output is a NoteNumber
 * User: dlyon
 * Date: Oct 6, 2003
 * Time: 5:33:00 PM
 * To change this template use Options | File Templates.
 */
package sound.musica;

import sound.*;

public class KeyMap {
    String keyString[] =
            {"`1234567890-",
             "qwertyuiop[]",
             "asdfghjkl;'",
             "zxcvbnm,./"
            };
    int scale[] = sound.musica.Scales2.getScale(
            Scales2.WHOLE_NOTES, 0, 8);
    int keyChars[] = new int[255];

    public KeyMap() {
        for (int i = 0; i < keyString.length; i++) {
            assignScale(keyString[i].toCharArray(), i);
        }
        System.out.println("Scale is:");
        println(scale);
    }

    public int getNoteNumber(int keyCharacter) {
        System.out.println(keyChars[keyCharacter]);
        return keyChars[keyCharacter];
    }

    public void assignScale(char row[], int rowNumber) {
        for (int i = 0; i < row.length; i++) {
            int nn = ((2 + rowNumber) * 12) + scale[i % scale.length];
            System.out.println("assign key:"
                    + (row[i]) + "=" + nn);
            keyChars[row[i]] = nn;
        }
    }

    public void println(int a[]) {
        for (int i = 0; i < a.length; i++) {
            System.out.println(a[i]);
        }
    }

    public void println(String s) {
        System.out.println(s);
    }

    public static void main(String args[]) {
        new KeyMap();
    }

}
