package sound.filterDesign;

// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   TimeDomainBean.java

import java.awt.*;
import java.awt.event.*;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.Vector;

public class TimeDomainBean extends Canvas
        implements ItemListener,
                   BodeListener,
                   MouseListener,
                   MouseMotionListener,
                   ActionListener,
                   Serializable {

    public TimeDomainBean() {
        lineColor = Color.red;
        impulseColor = Color.blue;
        titleColor = Color.black;
        title = "";
        myMouseListeners = new Vector();
        pcs = new PropertyChangeSupport(this);
        timeFrame = new TimeFrame(this);
        autoscale = true;
        showdelta = true;
        zoom = false;
        right = false;
        result = new Vector();
        racine = new Vector();
        lastParam = new Vector();
        residue = new Residue();
        pop = new PopupMenu();
        m1 = new CheckboxMenuItem("Autoscale", true);
        pop.add(m1);
        pop.add("-");
        m4 = new CheckboxMenuItem("Show impluse", true);
        pop.add(m4);
        pop.add("-");
        m2 = new MenuItem("Display equation");
        pop.add(m2);
        m3 = new MenuItem("Set parameters");
        pop.add(m3);
        add(pop);
        m1.addItemListener(this);
        m2.addActionListener(this);
        m3.addActionListener(this);
        m4.addItemListener(this);
        setBackground(Color.white);
        setForeground(Color.black);
        setFont(new Font("Dialog", 0, 12));
        setCursor(new Cursor(1));
        addMouseListener(this);
        addMouseMotionListener(this);
        newMouseX = newMouseY = oldMouseX = oldMouseY = 0;
        precision = 5;
        xMin = 0.0D;
        xMax = 20D;
        yMin = -1D;
        yMax = 1.0D;
        dW = dH = 40;
        gain = 1.0D;
        delta = 0.0D;
        thick = 1;
        lastParam.addElement(new Parameter(xMin, xMax, yMin, yMax));
    }

    public synchronized void paint(Graphics g) {
        update(g);
    }

    public synchronized void update(Graphics g) {
        Dimension dimension = getSize();
        if (offGraphics == null ||
                dimension.width != offDimension.width ||
                dimension.height != offDimension.height) {
            offDimension = dimension;
            offImage = createImage(dimension.width, dimension.height);
            offGraphics = offImage.getGraphics();
        }
        width = getSize().width;
        height = getSize().height;
        offGraphics.setColor(getBackground());
        offGraphics.fillRect(0,
                0,
                offDimension.width,
                offDimension.height);
        if (!zoom)
            calculate();
        offGraphics.setColor(getForeground());
        offGraphics.drawRect(0, 0, width - 1, height - 1);
        paintMe(offGraphics);
        g.drawImage(offImage, 0, 0, this);
    }

    public void calculate() {
        if (residue.getReadiness()) {
            result.removeAllElements();
            double d = ((xMax - xMin) / (double) (width - dW)) *
                    (double) precision;
            Complex complex = new Complex();
            Complex complex4 = new Complex(xMin, 0.0D);
            for (int i = 0; i < Residue.roots.length; i++) {
                for (int j = 0; j < residue.coeffs[i].length; j++) {
                    Complex complex2 = exp(Residue.roots[i].mul(complex4));
                    complex2 =
                            complex2.mul(
                                    complex4.pow(j).div(factorial(j)));
                    complex2 = complex2.mul(residue.coeffs[i][j]);
                    complex = complex.add(complex2);
                }

            }

            result.addElement(new Double(complex.getReal() + delta));
            if (autoscale)
                yMin = yMax = complex.getReal() + delta;
            for (double d1 = xMin + d; d1 <= xMax; d1 += d) {
                Complex complex1 = new Complex();
                Complex complex5 = new Complex(d1, 0.0D);
                for (int k = 0; k < Residue.roots.length; k++) {
                    for (int l = 0; l < residue.coeffs[k].length; l++) {
                        Complex complex3 = exp(
                                Residue.roots[k].mul(complex5));
                        complex3 =
                                complex3.mul(
                                        complex5.pow(l).div(factorial(l)));
                        complex3 = complex3.mul(residue.coeffs[k][l]);
                        complex1 = complex1.add(complex3);
                    }

                }

                result.addElement(new Double(complex1.getReal() + delta));
                if (autoscale) {
                    if (yMin > complex1.getReal() + delta)
                        yMin = complex1.getReal() + delta;
                    if (yMax < complex1.getReal() + delta)
                        yMax = complex1.getReal() + delta;
                }
            }

        }
    }

    public void paintMe(Graphics g) {
        drawAxes(g);
        if (result.size() != 0) {
            g.setColor(lineColor);
            int i = dW;
            int k = height -
                    (int) Math.rint(
                            ((((Double) result.elementAt(0)).doubleValue() -
                    yMin) *
                    (double) (height - dH - 1)) /
                    (yMax - yMin)) -
                    dH;
            for (int i2 = 1; i2 < result.size(); i2++) {
                int i1 = i + precision;
                int k1 = height -
                        (int) Math.rint(
                                ((((Double) result.elementAt(i2)).doubleValue() -
                        yMin) *
                        (double) (height - dH - 1)) /
                        (yMax - yMin)) -
                        dH;
                if (k1 > (height - dH) + 1)
                    k1 = height - dH;
                g.drawLine(i, k, i1, k1);
                if (thick == 2)
                    g.drawLine(i, k - 1, i1, k1 - 1);
                i = i1;
                k = k1;
            }

        }
        if (zoom) {
            int j;
            int l;
            if (oldMouseX < newMouseX) {
                j = oldMouseX;
                l = newMouseX;
            } else {
                j = newMouseX;
                l = oldMouseX;
            }
            int j1;
            int l1;
            if (oldMouseY > newMouseY) {
                j1 = oldMouseY;
                l1 = newMouseY;
            } else {
                j1 = newMouseY;
                l1 = oldMouseY;
            }
            g.setColor(getForeground());
            g.drawRect(j, l1, l - j, j1 - l1);
        }
        g.setColor(titleColor);
        FontMetrics fontmetrics = g.getFontMetrics();
        g.drawString(title,
                ((dW + width) - fontmetrics.stringWidth(title)) / 2,
                (fontmetrics.getMaxAscent() - fontmetrics.getMaxDescent()) +
                2);
        if (showdelta)
            drawDelta(g);
    }

    public double factorial(int i) {
        double d = 1.0D;
        if (i < 1)
            return d;
        for (int j = 2; j <= i; j++)
            d *= j;

        return d;
    }

    public void actionPerformed(ActionEvent actionevent) {
        Object obj = actionevent.getSource();
        if (obj == m3)
            timeFrame.wake();
    }

    public void itemStateChanged(ItemEvent itemevent) {
        Object obj = itemevent.getSource();
        if (obj == m1) {
            setAutoscale(m1.getState());
            return;
        }
        if (obj == m4)
            showImpulse(m4.getState());
    }

    public void changeOccured(BodeEvent bodeevent) {
        Vector vector1 = new Vector();
        if (bodeevent.getType() == 9 || bodeevent.getType() == 16) {
            gain = bodeevent.getGain();
            Vector vector = bodeevent.getPoles();
            synchronized (this) {
                if (vector != null && vector.size() > 0) {
                    racine.removeAllElements();
                    for (int i = 0; i < vector.size(); i++) {
                        Pole pole1 = (Pole) vector.elementAt(i);
                        racine.addElement(new Pole(pole1));
                        vector1.addElement(
                                new Complex(pole1.getReal(),
                                        pole1.getImag()));
                    }

                    rootsToPoly(racine, false);
                } else {
                    pole = new double[1];
                    pole[0] = 1.0D;
                }
            }
            vector = bodeevent.getZeros();
            if (vector != null && vector.size() > 0) {
                rootsToPoly(vector, true);
            } else {
                zero = new double[1];
                zero[0] = 1.0D;
            }
            residue.partial(zero, pole, vector1);
            delta = residue.getDelta();
        }
        repaint();
    }

    public void mouseEntered(MouseEvent mouseevent) {
    }

    public void mouseClicked(MouseEvent mouseevent) {
    }

    public void mouseExited(MouseEvent mouseevent) {
        fireMyMouseEvent(
                new MyMouseEvent(this, "Impulse reponse", 0.0D, 0.0D));
    }

    public void mouseMoved(MouseEvent mouseevent) {
        if (mouseevent.getX() >= dW && mouseevent.getY() <= height - dH) {
            double d = ((double) (mouseevent.getX() - dW) * (xMax - xMin)) /
                    (double) (width - dW) +
                    xMin;
            double d1 = ((double) (height - dH - mouseevent.getY()) *
                    (yMax - yMin)) /
                    (double) (height - dH) +
                    yMin;
            fireMyMouseEvent(
                    new MyMouseEvent(this, "Impulse reponse", d, d1));
            return;
        } else {
            fireMyMouseEvent(
                    new MyMouseEvent(this, "Impulse reponse", 0.0D, 0.0D));
            return;
        }
    }

    public void mouseReleased(MouseEvent mouseevent) {
        if ((mouseevent.getModifiers() & 0x10) == 16 && zoom) {
            zoom = false;
            right = false;
            if (oldMouseX != newMouseX && oldMouseY != newMouseY) {
                if (oldMouseX > newMouseX) {
                    int i = oldMouseX;
                    oldMouseX = newMouseX;
                    newMouseX = i;
                }
                if (oldMouseY < newMouseY) {
                    int j = oldMouseY;
                    oldMouseY = newMouseY;
                    newMouseY = j;
                }
                if (oldMouseX < dW)
                    oldMouseX = dW;
                lastParam.addElement(
                        new Parameter(xMin, xMax, yMin, yMax));
                if (lastParam.size() > 40)
                    lastParam.removeElementAt(0);
                double d = ((double) (oldMouseX - dW) * (xMax - xMin)) /
                        (double) (width - dW) +
                        xMin;
                xMax = ((double) (newMouseX - dW) * (xMax - xMin)) /
                        (double) (width - dW) +
                        xMin;
                xMin = d;
                d = ((double) (height - dH - oldMouseY) * (yMax - yMin)) /
                        (double) (height - dH) +
                        yMin;
                yMax = ((double) (height - dH - newMouseY) * (yMax - yMin)) /
                        (double) (height - dH) +
                        yMin;
                yMin = d;
                repaint();
            }
        }
        mouseevent.consume();
    }

    public void mousePressed(MouseEvent mouseevent) {
        if (mouseevent.isShiftDown()) {
            zoom = false;
            popup(mouseevent.getX(), mouseevent.getY());
        } else if ((mouseevent.getModifiers() & 0x10) == 16) {
            right = true;
            oldMouseX = newMouseX = mouseevent.getX();
            oldMouseY = newMouseY = mouseevent.getY();
        } else {
            right = false;
            int i;
            if ((i = lastParam.size()) > 1) {
                Parameter parameter = (Parameter) lastParam.elementAt(
                        i - 1);
                lastParam.removeElementAt(i - 1);
                xMin = parameter.getMinX();
                xMax = parameter.getMaxX();
                yMin = parameter.getMinY();
                yMax = parameter.getMaxY();
                repaint();
            }
        }
        mouseevent.consume();
    }

    public void mouseDragged(MouseEvent mouseevent) {
        if (right) {
            zoom = true;
            newMouseX = mouseevent.getX();
            newMouseY = mouseevent.getY();
            repaint();
        }
        double d = ((double) (mouseevent.getX() - dW) * (xMax - xMin)) /
                (double) (width - dW) +
                xMin;
        double d1 = ((double) (height - dH - mouseevent.getY()) *
                (yMax - yMin)) /
                (double) (height - dH) +
                yMin;
        fireMyMouseEvent(new MyMouseEvent(this, "Impulse reponse", d, d1));
        mouseevent.consume();
    }

    public void setAutoscale(boolean flag) {
        autoscale = flag;
        repaint();
    }

    public void showImpulse(boolean flag) {
        showdelta = flag;
        repaint();
    }

    public void popup(int i, int j) {
        pop.show(this, i, j);
    }

    public void drawAxes(Graphics g) {
        int i = dW;
        int j = width - 2;
        int k = 1;
        int l = height - dH;
        g.drawLine(i, k, i, l);
        g.drawLine(i, k, i - 3, k + 5);
        g.drawLine(i, k, i + 3, k + 5);
        g.drawString(d2str(yMax), 1, 10);
        g.drawString(d2str(yMin), 1, l + 5);
        g.drawLine(i, l, j, l);
        g.drawLine(j, l, j - 5, l + 3);
        g.drawLine(j, l, j - 5, l - 3);
        g.drawString(d2str(xMin), i - 5, l + 15);
        g.drawString(d2str(xMax), j - 35, l + 15);
    }

    public void drawDelta(Graphics g) {
        if (xMin == 0.0D && delta != 0.0D) {
            int i = height -
                    (int) Math.rint(
                            ((delta - yMin) * (double) (height - dH - 1)) /
                    (yMax - yMin)) -
                    dH;
            int j = height -
                    (int) Math.rint(
                            (-yMin * (double) (height - dH - 1)) /
                    (yMax - yMin)) -
                    dH;
            g.setColor(impulseColor);
            g.drawString("0.0", 2, j + 3);
            g.drawString(d2str(delta), 1, i + 3);
            g.drawLine(dW, j, dW, i);
            g.drawLine(dW + 1, j, dW + 1, i);
            if (delta < 0.0D) {
                g.drawLine(dW, i, dW - 3, i - 3);
                g.drawLine(dW, i, dW + 3, i - 3);
                return;
            }
            g.drawLine(dW, i, dW - 3, i + 3);
            g.drawLine(dW, i, dW + 3, i + 3);
        }
    }

    public String d2str(double d) {
        int i = 0;
        int j = 0;
        int k = 0;
        if ((new Double(d)).isInfinite())
            return "Inf";
        if (d != 0.0D) {
            byte byte0 = 1;
            if (d < 0.0D) {
                byte0 = -1;
                d = Math.abs(d);
            }
            while (d >= 10D) {
                d /= 10D;
                i++;
            }
            while (d < 1.0D) {
                d *= 10D;
                i--;
            }
            j = (int) d;
            if (j == 10) {
                j = 1;
                i++;
            }
            d *= 10D;
            k = (int) Math.rint(d - (double) (j * 10));
            if (k == 10) {
                j++;
                k = 0;
            }
            j *= byte0;
        }
        String s = j + "." + k + "E" + i;
        return s;
    }

    public Complex exp(Complex complex) {
        double d = Math.exp(complex.getReal());
        return new Complex(d * Math.cos(complex.getImag()),
                d * Math.sin(complex.getImag()));
    }

    public void rootsToPoly(Vector vector, boolean flag) {
        Vector vector1 = new Vector();
        if (flag) {
            for (int i = 0; i < vector.size(); i++) {
                Zero zero1 = new Zero((Zero) vector.elementAt(i));
                vector1.addElement(new Complex(zero1));
                if (zero1.getImag() != 0.0D)
                    vector1.addElement(new Complex(zero1.conj()));
            }

            Object obj = null;
        } else {
            for (int j = 0; j < vector.size(); j++) {
                Pole pole1 = new Pole((Pole) vector.elementAt(j));
                vector1.addElement(new Complex(pole1));
                if (pole1.getImag() != 0.0D)
                    vector1.addElement(new Complex(pole1.conj()));
            }

            Object obj1 = null;
        }
        Complex acomplex[] = new Complex[vector1.size() + 1];
        for (int k = 0; k < acomplex.length; k++)
            acomplex[k] = new Complex();

        acomplex[0] = new Complex(1.0D);
        acomplex[1] = new Complex((Complex) vector1.elementAt(0));
        for (int l = 1; l < vector1.size(); l++) {
            Complex complex = new Complex((Complex) vector1.elementAt(l));
            for (int i1 = l + 1; i1 > 0; i1--)
                acomplex[i1] =
                        acomplex[i1 - 1].mul(complex).add(acomplex[i1]);

        }

        if (flag) {
            zero = new double[acomplex.length];
            for (int j1 = 0; j1 < acomplex.length; j1++)
                zero[j1] = acomplex[j1].getReal();

            return;
        }
        pole = new double[acomplex.length];
        for (int k1 = 0; k1 < acomplex.length; k1++)
            pole[k1] = acomplex[k1].getReal();

    }

    public void oldParams(Vector vector) {
        params = vector;
        xMin = ((Double) params.elementAt(0)).doubleValue();
        xMax = ((Double) params.elementAt(1)).doubleValue();
        yMin = ((Double) params.elementAt(2)).doubleValue();
        yMax = ((Double) params.elementAt(3)).doubleValue();
        precision = ((Integer) params.elementAt(4)).intValue();
        gain = ((Double) params.elementAt(5)).doubleValue();
        thick = ((Integer) params.elementAt(6)).intValue();
        lastParam.removeAllElements();
        lastParam.addElement(new Parameter(xMin, xMax, yMin, yMax));
        repaint();
    }

    public Vector newParams() {
        params = new Vector();
        params.addElement(new Double(xMin));
        params.addElement(new Double(xMax));
        params.addElement(new Double(yMin));
        params.addElement(new Double(yMax));
        params.addElement(new Integer(precision));
        params.addElement(new Double(gain));
        return params;
    }

    public void setBackground(Color color) {
        Color color1 = getBackground();
        super.setBackground(color);
        pcs.firePropertyChange("background", color1, color);
    }

    public void setForeground(Color color) {
        Color color1 = getForeground();
        super.setForeground(color);
        pcs.firePropertyChange("foreground", color1, color);
    }

    public void setLineColor(Color color) {
        lineColor = color;
        repaint();
    }

    public Color getLineColor() {
        return lineColor;
    }

    public void setImpulseColor(Color color) {
        impulseColor = color;
        repaint();
    }

    public Color getImpulseColor() {
        return impulseColor;
    }

    public void setTitleColor(Color color) {
        titleColor = color;
        repaint();
    }

    public Color getTitleColor() {
        return titleColor;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String s) {
        title = s;
    }

    public Dimension getMinimumSize() {
        return new Dimension(20, 20);
    }

    public synchronized void addMyMouseListener(
            MyMouseListener mymouselistener) {
        myMouseListeners.addElement(mymouselistener);
    }

    public synchronized void removeMyMouseListener(
            MyMouseListener mymouselistener) {
        myMouseListeners.removeElement(mymouselistener);
    }

    public void fireMyMouseEvent(MyMouseEvent mymouseevent) {
        Vector vector = null;
        synchronized (this) {
            vector = (Vector) myMouseListeners.clone();
        }
        for (int i = 0; i < vector.size(); i++) {
            MyMouseListener mymouselistener = (MyMouseListener) vector.elementAt(
                    i);
            mymouselistener.mouseOccured(mymouseevent);
        }

    }

    boolean autoscale;
    boolean showdelta;
    boolean zoom;
    boolean right;
    private Color lineColor;
    private Color impulseColor;
    private Color titleColor;
    private String title;
    double zero[];
    double pole[];
    Vector racine;
    Vector result;
    Vector lastParam;
    double xMin;
    double xMax;
    double yMin;
    double yMax;
    double gain;
    double delta;
    int width;
    int height;
    int precision;
    int thick;
    int dW;
    int dH;
    int newMouseX;
    int newMouseY;
    int oldMouseX;
    int oldMouseY;
    Vector params;
    TimeFrame timeFrame;
    Residue residue;
    PopupMenu pop;
    MenuItem m2;
    MenuItem m3;
    CheckboxMenuItem m1;
    CheckboxMenuItem m4;
    Dimension offDimension;
    transient Image offImage;
    transient Graphics offGraphics;
    private Vector myMouseListeners;
    private PropertyChangeSupport pcs;
}
