package sound.filterDesign;

// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   Hs3DCanvas.java

import java.awt.*;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import java.util.Vector;

public class Hs3DCanvas extends Canvas
        implements Runnable,
                   MouseListener,
                   MouseMotionListener,
                   Serializable {

    public Hs3DCanvas() {
        width = 600;
        height = 600;
        setSize(width, height);
        setCursor(new Cursor(1));
        setBackground(Color.black);
        setForeground(Color.white);
        addMouseListener(this);
        addMouseMotionListener(this);
        NPOINTS = 20;
        X = new double[NPOINTS * NPOINTS];
        Y = new double[NPOINTS * NPOINTS];
        Z = new double[NPOINTS * NPOINTS];
        mag = new double[NPOINTS * NPOINTS];
        sx = new int[4];
        sy = new int[4];
        Zbuffer = new double[(NPOINTS - 1) * (NPOINTS - 1)];
        Fbuffer = new int[(NPOINTS - 1) * (NPOINTS - 1)];
        AXIS = true;
        WIRE = false;
        VALUE = false;
        SURF = true;
        PALETTE = 0;
        xan = 0.10000000000000001D;
        yan = 0.10000000000000001D;
        zan = 0.050000000000000003D;
        radius = 100D;
        zoom = 50D;
        zoom2 = 250D;
        cnst = 4D;
        cnst2 = 4D;
        Axis = new double[9];
        Axis[0] = Axis[4] = Axis[8] = 1.0D;
        Axis[1] = Axis[2] = Axis[3] = Axis[5] = Axis[6] = Axis[7] = 0.0D;
        thread = new Thread(this);
    }

    public void run() {
        do
            try {
                rotatePoints();
                rotateAxis();
                repaint();
                Thread.sleep(0L);
            } catch (InterruptedException _ex) {
            }
        while (true);
    }

    public void paint(Graphics g) {
        update(g);
    }

    public void update(Graphics g) {
        Dimension dimension = getSize();
        if (offGraphics == null ||
                dimension.width != offDimension.width ||
                dimension.height != offDimension.height) {
            offDimension = dimension;
            offImage = createImage(dimension.width, dimension.height);
            offGraphics = offImage.getGraphics();
        }
        offGraphics.setColor(getBackground());
        offGraphics.fillRect(0, 0, width, height);
        if (SURF)
            drawSurface(offGraphics);
        else if (WIRE)
            drawMesh(offGraphics);
        else
            drawWireframe(offGraphics);
        g.drawImage(offImage, 0, 0, this);
    }

    public void drawSurface(Graphics g) {
        for (int i = 0; i < NPOINTS - 1; i++) {
            for (int j = 0; j < NPOINTS - 1; j++) {
                Zbuffer[j + (NPOINTS - 1) * i] = Z[j + NPOINTS * i] +
                        Z[j + 1 + NPOINTS * (i + 1)] +
                        Z[j + NPOINTS * (i + 1)] +
                        Z[j + NPOINTS * i + 1];
                Fbuffer[j + (NPOINTS - 1) * i] = j + NPOINTS * i;
            }

        }

        QuickSort(Zbuffer, 0, Zbuffer.length - 1);
        for (int k = Zbuffer.length - 1; k > -1; k--) {
            int l = Fbuffer[k] % NPOINTS;
            int i1 = Fbuffer[k] / NPOINTS;
            sx[0] = (int) Math.rint(zoom * X[l + NPOINTS * i1]) +
                    width / 2;
            sy[0] = (int) Math.rint(zoom * Y[l + NPOINTS * i1]) +
                    height / 2;
            sx[1] = (int) Math.rint(zoom * X[l + NPOINTS * (i1 + 1)]) +
                    width / 2;
            sy[1] = (int) Math.rint(zoom * Y[l + NPOINTS * (i1 + 1)]) +
                    height / 2;
            sx[2] = (int) Math.rint(zoom * X[l + 1 + NPOINTS * (i1 + 1)]) +
                    width / 2;
            sy[2] = (int) Math.rint(zoom * Y[l + 1 + NPOINTS * (i1 + 1)]) +
                    height / 2;
            sx[3] = (int) Math.rint(zoom * X[l + NPOINTS * i1 + 1]) +
                    width / 2;
            sy[3] = (int) Math.rint(zoom * Y[l + NPOINTS * i1 + 1]) +
                    height / 2;
            switch (PALETTE) {
                case 0: // '\0'
                    g.setColor(
                            findColor(
                                    (mag[l + NPOINTS * i1] +
                            mag[l + NPOINTS * i1 + 1] +
                            mag[l + NPOINTS * (i1 + 1)] +
                            mag[l + 1 + NPOINTS * (i1 + 1)]) /
                            4D));
                    break;

                case 1: // '\001'
                    g.setColor(
                            findColor2(
                                    (mag[l + NPOINTS * i1] +
                            mag[l + NPOINTS * i1 + 1] +
                            mag[l + NPOINTS * (i1 + 1)] +
                            mag[l + 1 + NPOINTS * (i1 + 1)]) /
                            4D));
                    break;

                case 2: // '\002'
                    g.setColor(
                            findColor3(
                                    (mag[l + NPOINTS * i1] +
                            mag[l + NPOINTS * i1 + 1] +
                            mag[l + NPOINTS * (i1 + 1)] +
                            mag[l + 1 + NPOINTS * (i1 + 1)]) /
                            4D));
                    break;
            }
            g.fillPolygon(sx, sy, 4);
            if (WIRE) {
                g.setColor(Color.black);
                g.drawPolygon(sx, sy, 4);
            }
            if (k == Zbuffer.length / 2 + 1 && AXIS)
                drawAxis(g);
        }

    }

    public void drawMesh(Graphics g) {
        for (int i = 0; i < NPOINTS - 1; i++) {
            for (int j = 0; j < NPOINTS - 1; j++) {
                Zbuffer[j + (NPOINTS - 1) * i] = Z[j + NPOINTS * i] +
                        Z[j + 1 + NPOINTS * (i + 1)] +
                        Z[j + NPOINTS * (i + 1)] +
                        Z[j + NPOINTS * i + 1];
                Fbuffer[j + (NPOINTS - 1) * i] = j + NPOINTS * i;
            }

        }

        QuickSort(Zbuffer, 0, Zbuffer.length - 1);
        for (int k = Zbuffer.length - 1; k > -1; k--) {
            int l = Fbuffer[k] % NPOINTS;
            int i1 = Fbuffer[k] / NPOINTS;
            sx[0] = (int) Math.rint(zoom * X[l + NPOINTS * i1]) +
                    width / 2;
            sy[0] = (int) Math.rint(zoom * Y[l + NPOINTS * i1]) +
                    height / 2;
            sx[1] = (int) Math.rint(zoom * X[l + NPOINTS * (i1 + 1)]) +
                    width / 2;
            sy[1] = (int) Math.rint(zoom * Y[l + NPOINTS * (i1 + 1)]) +
                    height / 2;
            sx[2] = (int) Math.rint(zoom * X[l + 1 + NPOINTS * (i1 + 1)]) +
                    width / 2;
            sy[2] = (int) Math.rint(zoom * Y[l + 1 + NPOINTS * (i1 + 1)]) +
                    height / 2;
            sx[3] = (int) Math.rint(zoom * X[l + NPOINTS * i1 + 1]) +
                    width / 2;
            sy[3] = (int) Math.rint(zoom * Y[l + NPOINTS * i1 + 1]) +
                    height / 2;
            g.setColor(
                    findColor(
                            (mag[l + NPOINTS * i1] +
                    mag[l + NPOINTS * i1 + 1] +
                    mag[l + NPOINTS * (i1 + 1)] +
                    mag[l + 1 + NPOINTS * (i1 + 1)]) /
                    4D));
            g.drawPolygon(sx, sy, 4);
            if (k == Zbuffer.length / 2 + 1 && AXIS)
                drawAxis(g);
        }

    }

    public void drawWireframe(Graphics g) {
        g.setColor(new Color(-1 - getBackground().getRGB()));
        for (int i = 0; i < NPOINTS - 1; i++) {
            for (int j = 0; j < NPOINTS - 1; j++) {
                g.drawLine(
                        (int) Math.rint(zoom * X[j + NPOINTS * i]) +
                        width / 2,
                        (int) Math.rint(zoom * Y[j + NPOINTS * i]) +
                        height / 2,
                        (int) Math.rint(zoom * X[j + NPOINTS * (i + 1)]) +
                        width / 2,
                        (int) Math.rint(zoom * Y[j + NPOINTS * (i + 1)]) +
                        height / 2);
                g.drawLine(
                        (int) Math.rint(zoom * X[j + NPOINTS * i]) +
                        width / 2,
                        (int) Math.rint(zoom * Y[j + NPOINTS * i]) +
                        height / 2,
                        (int) Math.rint(zoom * X[j + NPOINTS * i + 1]) +
                        width / 2,
                        (int) Math.rint(zoom * Y[j + NPOINTS * i + 1]) +
                        height / 2);
            }

        }

        int k = NPOINTS * (NPOINTS - 1);
        for (int l = 0; l < NPOINTS - 1; l++) {
            g.drawLine((int) Math.rint(zoom * X[k + l]) + width / 2,
                    (int) Math.rint(zoom * Y[k + l]) + height / 2,
                    (int) Math.rint(zoom * X[k + l + 1]) + width / 2,
                    (int) Math.rint(zoom * Y[k + l + 1]) + height / 2);
            g.drawLine(
                    (int) Math.rint(zoom * X[(l + 1) * NPOINTS - 1]) +
                    width / 2,
                    (int) Math.rint(zoom * Y[(l + 1) * NPOINTS - 1]) +
                    height / 2,
                    (int) Math.rint(zoom * X[(l + 2) * NPOINTS - 1]) +
                    width / 2,
                    (int) Math.rint(zoom * Y[(l + 2) * NPOINTS - 1]) +
                    height / 2);
        }

        if (AXIS)
            drawAxis(g);
    }

    public void drawAxis(Graphics g) {
        g.setColor(new Color(-1 - getBackground().getRGB()));
        g.drawLine(width / 2,
                height / 2,
                (int) Math.rint(zoom2 * Axis[0]) + width / 2,
                (int) Math.rint(zoom2 * Axis[1]) + height / 2);
        g.drawString(" X ",
                (int) Math.rint(zoom2 * Axis[0]) + width / 2,
                (int) Math.rint(zoom2 * Axis[1]) + height / 2);
        g.drawLine(width / 2,
                height / 2,
                (int) Math.rint(zoom2 * Axis[3]) + width / 2,
                (int) Math.rint(zoom2 * Axis[4]) + height / 2);
        g.drawString(" Y ",
                (int) Math.rint(zoom2 * Axis[3]) + width / 2,
                (int) Math.rint(zoom2 * Axis[4]) + height / 2);
        g.drawLine(width / 2,
                height / 2,
                (int) Math.rint(zoom2 * Axis[6]) + width / 2,
                (int) Math.rint(zoom2 * Axis[7]) + height / 2);
        g.drawString(" Z ",
                (int) Math.rint(zoom2 * Axis[6]) + width / 2,
                (int) Math.rint(zoom2 * Axis[7]) + height / 2);
    }

    public void QuickSort(double ad[], int i, int j) {
        int k = i;
        int l = j;
        if (j > i) {
            double d = ad[(i + j) / 2];
            while (k <= l) {
                while (k < j && ad[k] < d)
                    k++;
                for (; l > i && ad[l] > d; l--) ;
                if (k <= l) {
                    swap(Zbuffer, k, l);
                    k++;
                    l--;
                }
            }
            if (i < l)
                QuickSort(ad, i, l);
            if (k < j)
                QuickSort(ad, k, j);
        }
    }

    private void swap(double ad[], int i, int j) {
        double d = ad[i];
        ad[i] = ad[j];
        ad[j] = d;
        int k = Fbuffer[i];
        Fbuffer[i] = Fbuffer[j];
        Fbuffer[j] = k;
    }

    public void mouseDragged(MouseEvent mouseevent) {
        xNew = mouseevent.getX() - width / 2;
        yNew = mouseevent.getY() - height / 2;
        Rotation(xNew - xOld, yNew - yOld);
        xOld = xNew;
        yOld = yNew;
        repaint();
    }

    public void mouseMoved(MouseEvent mouseevent) {
    }

    public void mouseClicked(MouseEvent mouseevent) {
    }

    public void mouseEntered(MouseEvent mouseevent) {
    }

    public void mouseExited(MouseEvent mouseevent) {
    }

    public void mousePressed(MouseEvent mouseevent) {
        xOld = mouseevent.getX() - width / 2;
        yOld = mouseevent.getY() - height / 2;
    }

    public void mouseReleased(MouseEvent mouseevent) {
    }

    public Color findColor2(double d) {
        return new Color(Color.HSBtoRGB((float) (d / cnst), 1.0F, 1.0F));
    }

    public Color findColor3(double d) {
        return new Color(
                Color.HSBtoRGB(1.0F - (float) (d / cnst), 1.0F, 1.0F));
    }

    public Color findColor(double d) {
        int i;
        if (d < 1.0D / cnst)
            i = (int) (d * 200D * cnst) + 56;
        else if (d < 5D / cnst) {
            i = (int) (d * 40D * cnst) + 56;
            i <<= 8;
        } else if (d > 20D / cnst) {
            i = 0xffffff;
        } else {
            i = (int) (d * 10D * cnst) + 56;
            i <<= 16;
        }
        return new Color(i);
    }

    public void calculate() {
        for (int i = 0; i < NPOINTS; i++) {
            double d = (2D * xmax * (double) i) / (double) (NPOINTS - 1) -
                    xmax;
            for (int j = 0; j < NPOINTS; j++) {
                double d1 = (2D * ymax * (double) j) /
                        (double) (NPOINTS - 1) -
                        ymax;
                double d2 = 1.0D;
                for (int k = 0; k < zeros.size(); k++) {
                    double d3 = ((Zero) zeros.elementAt(k)).getReal();
                    double d5 = ((Zero) zeros.elementAt(k)).getImag();
                    d2 *= (d3 - d) * (d3 - d) + (d5 - d1) * (d5 - d1);
                    if (d5 != 0.0D) {
                        d5 = -d5;
                        d2 *= (d3 - d) * (d3 - d) + (d5 - d1) * (d5 - d1);
                    }
                }

                for (int l = 0; l < poles.size(); l++) {
                    double d4 = ((Pole) poles.elementAt(l)).getReal();
                    double d6 = ((Pole) poles.elementAt(l)).getImag();
                    d2 /= (d4 - d) * (d4 - d) + (d6 - d1) * (d6 - d1);
                    if (d6 != 0.0D) {
                        d6 = -d6;
                        d2 /= (d4 - d) * (d4 - d) + (d6 - d1) * (d6 - d1);
                    }
                }

                d2 = Math.sqrt(d2);
                X[j + NPOINTS * i] = d;
                Y[j + NPOINTS * i] = d1;
                Z[j + NPOINTS * i] = d2 <= cnst ? d2 : cnst;
                mag[j + NPOINTS * i] = d2 <= 4D * cnst ? d2 / cnst : cnst;
            }

        }

    }

    public void rotatePoints() {
        for (int i = 0; i < NPOINTS; i++) {
            for (int j = 0; j < NPOINTS; j++) {
                double d1 = Y[j + NPOINTS * i] * Math.cos(xan) -
                        Z[j + NPOINTS * i] * Math.sin(xan);
                double d2 = Y[j + NPOINTS * i] * Math.sin(xan) +
                        Z[j + NPOINTS * i] * Math.cos(xan);
                Y[j + NPOINTS * i] = d1;
                Z[j + NPOINTS * i] = d2;
                double d = X[j + NPOINTS * i] * Math.cos(yan) -
                        Z[j + NPOINTS * i] * Math.sin(yan);
                d2 = X[j + NPOINTS * i] * Math.sin(yan) +
                        Z[j + NPOINTS * i] * Math.cos(yan);
                X[j + NPOINTS * i] = d;
                Z[j + NPOINTS * i] = d2;
                d = X[j + NPOINTS * i] * Math.cos(zan) -
                        Y[j + NPOINTS * i] * Math.sin(zan);
                d1 = X[j + NPOINTS * i] * Math.sin(zan) +
                        Y[j + NPOINTS * i] * Math.cos(zan);
                X[j + NPOINTS * i] = d;
                Y[j + NPOINTS * i] = d1;
            }

        }

    }

    public void rotateAxis() {
        for (int i = 0; i < 3; i++) {
            double d1 = Axis[1 + i * 3] * Math.cos(xan) -
                    Axis[2 + i * 3] * Math.sin(xan);
            double d2 = Axis[1 + i * 3] * Math.sin(xan) +
                    Axis[2 + i * 3] * Math.cos(xan);
            Axis[1 + i * 3] = d1;
            Axis[2 + i * 3] = d2;
            double d = Axis[i * 3] * Math.cos(yan) -
                    Axis[2 + i * 3] * Math.sin(yan);
            d2 = Axis[i * 3] * Math.sin(yan) +
                    Axis[2 + i * 3] * Math.cos(yan);
            Axis[i * 3] = d;
            Axis[2 + i * 3] = d2;
            d = Axis[i * 3] * Math.cos(zan) -
                    Axis[1 + i * 3] * Math.sin(zan);
            d1 = Axis[i * 3] * Math.sin(zan) +
                    Axis[1 + i * 3] * Math.cos(zan);
            Axis[i * 3] = d;
            Axis[1 + i * 3] = d1;
        }

    }

    public void Rotation(int i, int j) {
        if (i != 0 && j != 0) {
            double d8 = Math.sqrt(i * i + j * j);
            double d9 = Math.sqrt(radius * radius + d8 * d8);
            double d6 = radius / d9;
            double d7 = d8 / d9;
            double d10 = (double) j / d8;
            double d11 = -(double) i / d8;
            double d12 = 1.0D - d6;
            for (int k = 0; k < NPOINTS; k++) {
                for (int l = 0; l < NPOINTS; l++) {
                    double d = X[l + NPOINTS * k] *
                            (d6 + d10 * d10 * d12);
                    d += Y[l + NPOINTS * k] * d10 * d11 * d12;
                    d += Z[l + NPOINTS * k] * d11 * d7;
                    double d2 = X[l + NPOINTS * k] * d10 * d11 * d12;
                    d2 += Y[l + NPOINTS * k] * (d6 + d11 * d11 * d12);
                    d2 += -Z[l + NPOINTS * k] * d10 * d7;
                    double d4 = -X[l + NPOINTS * k] * d11 * d7;
                    d4 += Y[l + NPOINTS * k] * d10 * d7;
                    d4 += Z[l + NPOINTS * k] * d6;
                    X[l + NPOINTS * k] = d;
                    Y[l + NPOINTS * k] = d2;
                    Z[l + NPOINTS * k] = d4;
                }

            }

            for (int i1 = 0; i1 < 3; i1++) {
                double d1 = Axis[3 * i1] * (d6 + d10 * d10 * d12);
                d1 += Axis[1 + 3 * i1] * d10 * d11 * d12;
                d1 += Axis[2 + 3 * i1] * d11 * d7;
                double d3 = Axis[3 * i1] * d10 * d11 * d12;
                d3 += Axis[1 + 3 * i1] * (d6 + d11 * d11 * d12);
                d3 += -Axis[2 + 3 * i1] * d10 * d7;
                double d5 = -Axis[3 * i1] * d11 * d7;
                d5 += Axis[1 + 3 * i1] * d10 * d7;
                d5 += Axis[2 + 3 * i1] * d6;
                Axis[3 * i1] = d1;
                Axis[1 + 3 * i1] = d3;
                Axis[2 + 3 * i1] = d5;
            }

        }
    }

    public void newInfo(Vector vector,
                        Vector vector1,
                        double d,
                        double d1) {
        xmax = Math.max(d, d1);
        ymax = xmax;
        cnst = 2D * d;
        zoom = 200D / cnst;
        zeros = new Vector();
        poles = new Vector();
        synchronized (this) {
            if (vector1 != null && vector1.size() > 0) {
                for (int i = 0; i < vector1.size(); i++)
                    poles.addElement(new Pole((Pole) vector1.elementAt(i)));

            }
            if (vector != null && vector.size() > 0) {
                for (int j = 0; j < vector.size(); j++)
                    zeros.addElement(new Zero((Zero) vector.elementAt(j)));

            }
        }
        Axis[0] = Axis[4] = Axis[8] = 1.0D;
        Axis[1] = Axis[2] = Axis[3] = Axis[5] = Axis[6] = Axis[7] = 0.0D;
        calculate();
        repaint();
    }

    public void newBgcolor(Color color) {
        setBackground(color);
        repaint();
    }

    public void newNpoints(int i) {
        NPOINTS = i;
        X = new double[NPOINTS * NPOINTS];
        Y = new double[NPOINTS * NPOINTS];
        Z = new double[NPOINTS * NPOINTS];
        mag = new double[NPOINTS * NPOINTS];
        Zbuffer = new double[(NPOINTS - 1) * (NPOINTS - 1)];
        Fbuffer = new int[(NPOINTS - 1) * (NPOINTS - 1)];
        Axis[0] = Axis[4] = Axis[8] = 1.0D;
        Axis[1] = Axis[2] = Axis[3] = Axis[5] = Axis[6] = Axis[7] = 0.0D;
        calculate();
        repaint();
    }

    public void stopThread() {
        if (thread != null) {
            thread = null;
        }
    }

    public void startThread() {
        if (thread == null)
            thread = new Thread(this);
        thread.start();
    }

    public void valueOn(boolean flag) {
        VALUE = flag;
        repaint();
    }

    public void wireOn(boolean flag) {
        WIRE = flag;
        repaint();
    }

    public void axisOn(boolean flag) {
        AXIS = flag;
        repaint();
    }

    public void surfOn(boolean flag) {
        SURF = flag;
        repaint();
    }

    public void palette(int i) {
        PALETTE = i;
        repaint();
    }

    public void rotOn(boolean flag) {
        if (flag) {
            startThread();
            return;
        } else {
            stopThread();
            return;
        }
    }

    Vector zeros;
    Vector poles;
    double X[];
    double Y[];
    double Z[];
    double mag[];
    int sx[];
    int sy[];
    double Zbuffer[];
    int Fbuffer[];
    double Axis[];
    int width;
    int height;
    int xNew;
    int yNew;
    int xOld;
    int yOld;
    double xmax;
    double ymax;
    double K;
    double xan;
    double yan;
    double zan;
    double zoom;
    double zoom2;
    double cnst;
    double cnst2;
    double radius;
    int NPOINTS;
    int PALETTE;
    boolean AXIS;
    boolean WIRE;
    boolean VALUE;
    boolean SURF;
    Dimension offDimension;
    Image offImage;
    Graphics offGraphics;
    transient Thread thread;
}
