package sound.audioDigitizer;

import gui.ClosableJFrame;
import gui.run.RunSlider;
import sound.OscopePanel;
import sound.ulaw.UlawCodec;
import sound.Utils;

import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

/**
 * DocJava, Inc.
 * http://www.docjava.com
 * Programmer: dlyon
 * Date: Dec 6, 2004
 * Time: 2:37:32 PM
 */
public class StreamingPlaybackThread
        extends Thread implements Runnable {
    SourceDataLine line;
    String errStr = null;
    AudioInputStream ais = null;
    private final int bufSize = 16384;
    CapturePlayBackOscope.FormatControls formatControls = null;

    public StreamingPlaybackThread(AudioInputStream ais,
                                   CapturePlayBackOscope.FormatControls formatControls) {
        this.ais = ais;
        this.formatControls = formatControls;
        createControlPanel();
    }

    long delay = 100;

    private void setDelay(long d) {
        delay = d;
    }

    private long getDelay() {
        return delay;
    }

    OscopePanel osp = new OscopePanel();

    private void createControlPanel() {
        System.out.println("createControlPanel was called");
        ClosableJFrame cf = new ClosableJFrame();
        Container c = cf.getContentPane();
        JPanel jp = new JPanel() {
            public Dimension getPreferredSize() {
                return new Dimension(100, 100);
            }
        };
        jp.setLayout(new BoxLayout(jp, BoxLayout.PAGE_AXIS));
        jp.add(new RunSlider() {
            public void run() {
                setDelay(this.getValue() * 10000);
            }
        });
        jp.add(new RunSlider() {
            public void run() {
                setDelay(this.getValue() * 10000);
            }
        });
        jp.add(new RunSlider() {
            public void run() {
                setDelay(this.getValue() * 10000);
            }
        });
        jp.add(new RunSlider() {
            public void run() {
                setDelay(this.getValue() * 10000);
            }
        });
        c.setLayout(new BorderLayout());
        c.add(jp, BorderLayout.SOUTH);
        c.add(osp, BorderLayout.CENTER);
        cf.setSize(200, 200);
        cf.setVisible(true);
    }

    private void shutDown(String message) {
        if ((errStr = message) != null) {
            System.err.println(errStr);
        }
    }

    public static void printFormat(AudioFormat af) {
        System.out.println("--------");
        System.out.println(af);
    }

    public void run() {
        AudioFormat format = getAudioFormat();

        AudioInputStream playbackInputStream = AudioSystem.getAudioInputStream(format, ais);
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, format);
        printFormat(format);
        try {
            line = (SourceDataLine) AudioSystem.getLine(info);
            line.open(format, bufSize);
        } catch (LineUnavailableException ex) {
            shutDown("Unable to open the line: " + ex);
        }
        // play back the captured audio data

        int frameSizeInBytes = format.getFrameSize();
        int bufferLengthInFrames = line.getBufferSize() / 8;
        int bufferLengthInBytes = bufferLengthInFrames * frameSizeInBytes;
        int numBytesRead = 0;

        // start the source data line
        line.start();
        while (true) {
            int n = (int) getDelay();
            byte[] data = new byte[n];
            try {
                if ((numBytesRead = playbackInputStream.read(data)) == -1) {
                    // Thread.sleep(100);
                }
                int numBytesRemaining = numBytesRead;
                processData(format, data, numBytesRemaining);
            } catch (Exception e) {
                shutDown("Error during playback: " + e);
                break;
            }
        }
        cleanUp();
    }

    private void processData(AudioFormat af, byte[] data, int numBytesRemaining) {
            final double[] doubleData = Utils.getDoubleData(af,data);
            osp.setData(doubleData);
            Utils.echo(1,1,doubleData);
    }

    public static double[] getDoubleData(byte b[]) {
        UlawCodec ulc = new UlawCodec(b);
        return ulc.getDoubleArray();
    }

    private void cleanUp
            () {
        // we reached the end of the stream.  let the data play out, then
        // stop and close the line.

        line.drain();
        line.stop();
        line.close();
        line = null;
        shutDown(null);
    }

    private AudioFormat getAudioFormat
            () {
        // make sure we have something to play
        if (ais == null)
            shutDown("No loaded audio to play back");

        // get an AudioInputStream of the desired format for playback
        AudioFormat format = formatControls.getFormat();
        return format;
    }
}

