package sound.audioDigitizer;

import sound.soundDemo.JavaSound;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.TargetDataLine;
import java.io.IOException;

/**
 * DocJava, Inc.
 * http://www.docjava.com
 * Programmer: dlyon
 * Date: Nov 29, 2004
 * Time: 3:20:19 PM
 */
public class StreamAudio implements Runnable {
    TargetDataLine targetDataLine;
    Thread thread;
    String errStr = "";
    CapturePlayBackOscope.FormatControls formatControls
            = new CapturePlayBackOscope.FormatControls();

    public StreamAudio() {
    }

    public static void main(String[] args) {
        StreamAudio sa = new StreamAudio();
        sa.start();
    }

    public void start() {
        errStr = null;
        thread = new Thread(this);
        thread.setName("Capture");
        thread.start();
    }

    public void stop() {
        thread = null;
    }

    public void run() {
        AudioFormat format = initAudioStuff();
        int numBytesRead;
        targetDataLine.start();
        processAudioData();

        // we reached the end of the stream.  stop and close the line.
        targetDataLine.stop();
        targetDataLine.close();
        targetDataLine = null;
    }

    private void processAudioData() {
        AudioInputStream ais = new AudioInputStream(targetDataLine);
        StreamingPlaybackThread sp = new StreamingPlaybackThread(ais, formatControls);
        sp.start();
        while (thread != null) {
            System.out.println("Running!");
            try {
                Thread.sleep(1000);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        try {
            ais.reset();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    private AudioFormat initAudioStuff() {
        // define the required attributes for our line,
        // and make sure a compatible line is supported.

        AudioFormat format = formatControls.getFormat();
        DataLine.Info info = new DataLine.Info(TargetDataLine.class,
                format);
        if (!AudioSystem.isLineSupported(info)) {
            shutDown("Line matching " + info + " not supported.");
        }
        getAndInitTDL(info, format);
        return format;
    }

    private void getAndInitTDL(DataLine.Info info, AudioFormat format) {
        // get and open the target data line for capture.

        try {
            initTargetDataLine(info, format);
        } catch (LineUnavailableException ex) {
            shutDown("Unable to open the line: " + ex);
        } catch (SecurityException ex) {
            JavaSound.showInfoDialog();
        } catch (Exception ex) {
        }
    }

    public void initTargetDataLine(DataLine.Info info, AudioFormat format)
            throws LineUnavailableException {
        targetDataLine = (TargetDataLine) AudioSystem.getLine(info);
        targetDataLine.open(format, targetDataLine.getBufferSize());
    }

    private void shutDown(String s) {
        System.out.println(s);
        System.exit(0);
    }
}

