package sound;

/*
 * Open Source Software by http://www.Docjava.com
 * programmer: D. Lyon
 * e-mail: lyon@docjava.com
 * Date: Apr 29, 2002
 * Time: 12:57:33 PM
 */

public class StochasticControl {
    public static void testRandomNotes() {
        randomNotes(12, 70, 100, 250);
    }

    /**

     * play randomNotes from a scale

     */
    public static void randomNotes(
            int scale[], int numberOfNotes) {
        for (int i = 0; i < numberOfNotes; i++) {
            int r = getRandom(0, scale.length);
            Utils.play(scale[r], 50 * getRandom(1, 4));
        }
    }

    public static void randomNotes(int noteMin, int noteMax,
                                   int numberOfNotes,
                                   int duration) {
        for (int i = 0; i < numberOfNotes; i++)
            Utils.play(getRandom(noteMin, noteMax), duration);
    }

    private static void testRandom() {
        for (int i = 0; i < 10; i++)
            System.out.println(getRandom(1, 12));
    }

    public static int getRandom(int min, int max) {
        return (int) ((max - min) * Math.random() + min);
    }
}
