/**
 * Created by IntelliJ IDEA.
 * User: dlyon
 * Date: Nov 17, 2003
 * Time: 7:44:50 PM
 * To change this template use Options | File Templates.
 */
package sound;


import gui.ClosableJFrame;
import gui.run.RunButton;
import gui.run.RunSlider;

import javax.swing.*;
import java.awt.*;

import sound.ulaw.UlawCodec;

public class OscillatorPanel extends JPanel {
    private int frequency = 440;
    private int duration = 1000;
    private Oscillator os = new Oscillator(frequency, duration);
    OscopePanel osp = new OscopePanel();

    public int getFrequency() {
        return frequency;
    }

    public static void main(String args[]) {
        ClosableJFrame cf = new ClosableJFrame("OscilatorFrame");
        Container c = cf.getContentPane();
        c.setLayout(new GridLayout(1,0));
        c.add(new OscillatorPanel());
        c.add(new OscillatorPanel());
        c.add(new OscillatorPanel());
        c.add(new OscillatorPanel());
        cf.setSize(550, 400);
        cf.show();

    }

    private void setDuration(int d) {
        duration = d;
    }

    private RunSlider getFrequencySlider() {
        return new RunSlider(RunSlider.HORIZONTAL) {
            public void run() {
                setFrequency(10 * getValue());
                playSineWave();
            }
        };
    }

    private RunSlider getDurationSlider() {
        return new RunSlider(RunSlider.HORIZONTAL) {
            public void run() {
                setDuration(100 * getValue());
            }
        };
    }

    public JPanel getButtonControlPanel() {
        JPanel jp = new JPanel();
        jp.setLayout(new FlowLayout());
        jp.add(getPlaySawWaveButton());
        jp.add(getPlaySquareWaveButton());
        jp.add(getPlayTriangleWaveButton());
        jp.add(getPlaySineWaveButton());
        return jp;
    }

    public RunButton getPlayTriangleWaveButton() {
        return new RunButton("triangle") {
            public void run() {
                playTriangleWave();
            }
        };
    }

    public RunButton getPlaySineWaveButton() {
        return new RunButton("sine") {
            public void run() {
                playSineWave();
            }
        };
    }

    public RunButton getPlaySawWaveButton() {
        return new RunButton("saw") {
            public void run() {
                playSawWave();
            }
        };
    }

    public RunButton getPlaySquareWaveButton() {
        return new RunButton("square") {
            public void run() {
                playSquareWave();
            }
        };
    }

    public OscillatorPanel() {
        setLayout(new BorderLayout());
        add(getControlPanel(), BorderLayout.NORTH);

        add(getOscopePanel(), BorderLayout.CENTER);
        add(getButtonPanel(), BorderLayout.SOUTH);
    }
   private JPanel getOscopePanel() {
        JPanel jp = new JPanel();
        jp.setLayout(new GridLayout());
        jp.add(osp);
        return jp;
    }
    private JPanel getControlPanel() {
        JPanel jp = new JPanel();
        jp.setLayout(new GridLayout(2,0));
        jp.add(getFrequencySlider());
        jp.add(getDurationSlider());
        return jp;
    }

    private JPanel getButtonPanel() {
        JPanel jp = new JPanel();
        jp.setLayout(new GridLayout(2,0));
        jp.add(getPlaySawWaveButton());
        jp.add(getPlaySquareWaveButton());
        jp.add(getPlayTriangleWaveButton());
        jp.add(getPlaySineWaveButton());
        return jp;
    }


    public void playSquareWave() {
        os = new Oscillator(frequency, duration);
        UlawCodec ulc = new UlawCodec(os.getSquareWave());
        playAndUpdateDisplay(ulc);
    }

    public void playSawWave() {
        os = new Oscillator(frequency, duration);
        UlawCodec ulc = new UlawCodec(os.getSawWave());
        playAndUpdateDisplay(ulc);
    }

    public void playTriangleWave() {
        os = new Oscillator(frequency, duration);
        UlawCodec ulc = new UlawCodec(os.getTriangleWave());
        playAndUpdateDisplay(ulc);
    }

    public void playSineWave() {
        os = new Oscillator(frequency, duration);
        UlawCodec ulc = new UlawCodec(os.getSineWave());
        playAndUpdateDisplay(ulc);
    }

    private void playAndUpdateDisplay(UlawCodec ulc) {
        osp.setData(ulc.getDoubleArray());
        osp.repaint(500);
        ulc.play();
    }

    public void setFrequency(int f) {
        frequency = f;
    }

}
