package serialPorts;

import sun.misc.ClassFileTransformer;
import sun.misc.CompoundEnumeration;
import sun.misc.Resource;
import sun.misc.URLClassPath;
import sun.reflect.Reflection;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.security.*;
import java.util.*;


class SystemClassLoaderAction implements PrivilegedExceptionAction {
    private ClassLoader parent;

    SystemClassLoaderAction(ClassLoader parent) {
        this.parent = parent;
    }

    public Object run() throws Exception {
        ClassLoader sys;
        Constructor ctor;
        Class c;
        Class cp[] = {ClassLoader.class};
        Object params[] = {parent};

        String cls = System.getProperty("java.system.class.loader");
        if (cls == null) {
            return parent;
        }

        c = Class.forName(cls, true, parent);
        ctor = c.getDeclaredConstructor(cp);
        sys = (ClassLoader) ctor.newInstance(params);
        Thread.currentThread().setContextClassLoader(sys);
        return sys;
    }

}

