package security;

// security.WebStartUtils

import classUtils.putils.ClassPathUtils;
import futils.Futil;
import gui.In;
import net.scp.ScpBean;
import utils.SystemUtils;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.security.KeyStore;
import java.util.Date;
import java.util.jar.JarFile;


/**
 * DocJava, Inc. User: lyon Date: May 26, 2004 Time: 10:39:47 AM
 */
public class WebStartUtils {
    String passwordField1 = "";

    public static void upLoadEmbeddedClass() {
        try {
            packSignUploadJNLP(
                    ClassPathUtils.getClassFromFile());
        } catch (Exception e) {
            In.message(e);
            System.exit(0);
        }
        In.message("finised with up load:");
        System.exit(0);
    }

    public static void generalUpload() throws Exception {
        String className = In.getString("enter class name");
        ClassPathUtils.getClass(className);
        final File keyStoreFile =
                KeyUtils.getKeystoreFile();
        String vendor = In.getString("enter vendor");
        String url = In.getString("enter URL");
        final String password = In.getPassword("enter keystore password");
        KeyStore ks = KeyUtils.getKeyStore(password);
        final String alias = KeyUtils.getAlias(ks);
        String codeBase = In.getString("enter codebase, for example:" +
                "http://show.docjava.com:8086/" +
                "book/cgij/code/jnlp/");
        String iconUrl = In.getString("enter icon url, for example:" +
                "http://show.docjava.com:8086/" +
                "consulti/docjava.jpe");
        String user = In.getString("enter uid, for example:lyon");
        String host = In.getString("enter target upload host, " +
                "for example:" +
                "192.168.1.95");
        final String rootDirectory = In.getString("enter root directory on upload host," +
                " for example:/var/www/html/book/" +
                "cgij/code/jnlp/");
        String jarFileName = className +
                ".jar";
        Initium.packSignAndUpload(className,
                jarFileName,
                keyStoreFile,
                password,
                alias,
                vendor,
                url,
                codeBase,
                iconUrl,
                user,
                host,
                rootDirectory);
        In.message("finish upload");
        System.exit(0);
    }

    public static void packSignUploadJNLP() throws Exception {
        packSignUploadJNLP(gui.In.getString("enter class name"));
    }

    public static void packSignUploadJNLP(Class c) throws Exception {
        packSignUploadJNLP(c.getName());
    }

    public static void packSignUploadJNLP(String mainClassName)
            throws Exception {

        ClassPathUtils.getClass(mainClassName);
        final File keyStoreFile =
                KeyUtils.getKeystoreFile();
        //= futils.Futil.getReadFile(
        //"select keystore");
        String vendor = "DocJava, Inc.";
        String url = "http://www.docjava.com";
        final String password = In.getPassword("enter keystore password");
        KeyStore ks = KeyUtils.getKeyStore(password);
        final String alias = KeyUtils.getAlias(ks);
        String codeBase = "http://show.docjava.com:8086/" +
                "book/cgij/code/jnlp/";
        String iconUrl = "http://show.docjava.com:8086/" +
                "consulti/docjava.jpe\"";
        String user = "lyon";
        String webServer = "192.168.1.95";
        final String rootDirectory = "/var/www/html/book/cgij/code/jnlp/";
        String jarFileName = mainClassName +
                ".jar";


        Initium.packSignAndUpload(mainClassName,
                jarFileName,
                keyStoreFile,
                password,
                alias,
                vendor,
                url,
                codeBase,
                iconUrl,
                user,
                webServer,
                rootDirectory);
    }

    public static void packSignOutputJnlp(final String mainClassName,
                                          final File keyStoreFile,
                                          final String password,
                                          final String alias,
                                          String vendor,
                                          String url) throws Exception {
        String codeBase = "http://show.docjava.com:8086/book/cgij/code/jnlp/";
        String iconUrl = "http://show.docjava.com:8086/consulti/docjava.jpe\"";
        String user = "lyon";
        String webServer = "192.168.1.95";
        final String rootDirectory = "/var/www/html/book/cgij/code/jnlp/";
        String jarFileName = mainClassName +
                ".jar";
        Initium.packSignAndUpload(mainClassName,
                jarFileName,
                keyStoreFile,
                password,
                alias,
                vendor,
                url,
                codeBase,
                iconUrl,
                user,
                webServer,
                rootDirectory);

        //SignUtils.verify(jarFileName);
        verifyJar(jarFileName);
    }

    /**
     * Use the built-in JarVerifier class to verify the existance and
     * signing of the Jar file.
     */
    public static void verifyJar(String jarFileName) {
        try {
            new JarFile(jarFileName);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    /**
     * Synthesize and upload the JNLP and Jar files.
     *
     * @param title       Application title
     * @param vendor      Application owner
     * @param localJarFile A packed jar file
     * @param mainClass   A fully qualified class name
     * @param localJnlpFile    The JNLP used for launching
     */
    public static void upLoadJnlp(String title,
                                  String vendor,
                                  String homePage,
                                  String localJarFile,
                                  String mainClass,
                                  File localJnlpFile,
                                  String codeBase,
                                  String iconUrl,
                                  String user,
                                  String host,
                                  String rootDirectory) {
        String jnlpFileConents = getJnlpFileContents(localJnlpFile,
                codeBase,
                title,
                vendor,
                homePage,
                iconUrl,
                localJarFile,
                mainClass);
        try {
            saveToDisk(localJnlpFile, jnlpFileConents);
            String remoteJnlpFile = rootDirectory +
                    localJnlpFile.getName();
            String remoteJarFile = rootDirectory +
                    localJarFile;
            ScpBean scpBean = getScpBean(user,
                    host,
                    localJnlpFile,
                    remoteJnlpFile);
            scpBean.upload();
            scpBean.setLocalFile(localJarFile);
            scpBean.setRemoteFile(remoteJarFile);
            scpBean.upload();

            print("done with xfer at:" +
                    new Date());
            localJnlpFile.deleteOnExit();
            new File(localJarFile).deleteOnExit();
        } catch (IOException e) {
            In.message(e);
        }
    }

    private static String getJnlpFileContents(File localJnlpFile,
                                              String codeBase,
                                              String title,
                                              String vendor,
                                              String homePage,
                                              String iconUrl,
                                              String localJarFile,
                                              String mainClass) {
        String cmd =
                "<jnlp href=\"" +
                localJnlpFile.getName() +
                "\" codebase=\"" +
                codeBase +
                "\">\n" +
                "  <information>\n" +
                "    <title>" +
                title +
                "</title>\n" +
                "    <vendor>" +
                vendor +
                "</vendor>\n" +
                "    <homepage href=\"" +
                homePage +
                "\"/>\n" +
                "<icon href=\"" +
                iconUrl +
                "\"/>" +
                "\n" +
                "    <offline-allowed />\n" +
                "  </information>\n" +
                "  \n" +
                "  <security>\n" +
                "    <all-permissions />\n" +
                "  </security>\n" +
                "  \n" +
                "  <resources>\n" +
                "    <j2se version=\"" +
                "1.4+" +
                "\" />\n" +
                "    <jar href=\"" +
                localJarFile +
                "\" />\n" +
                "  </resources>\n" +
                " \n" +
                "  <application-desc main-class=\"" +
                mainClass +
                "\" />\n" +
                "</jnlp>\n";
        return cmd;
    }

    private static ScpBean getScpBean(String user,
                                      String host,
                                      File jnlpFile, String rJnlpFile) {
        ScpBean scpBean = ScpBean.restore();
        scpBean.setUser(user);
        scpBean.setHost(host);
        scpBean.setLocalFile(jnlpFile.toString());
        scpBean.setRemoteFile(rJnlpFile);
        scpBean.setScp(true);
        return scpBean;
    }

    public static void print(Object o) {
        System.out.println(o);
    }

    public static void writeJnlp(String title,
                                 String vendor,
                                 String homePage,
                                 String jarFileName,
                                 String mainClass,
                                 File jnlpFile,
                                 String codeBase) {
        String jnlpData =
                "<jnlp href=\"" +
                jnlpFile.getName() +
                "\" codebase=\"file://" +
                codeBase +
                "\">\n" +
                "  <information>\n" +
                "    <title>" +
                title +
                "</title>\n" +
                "    <vendor>" +
                vendor +
                "</vendor>\n" +
                "    <homepage href=\"" +
                homePage +
                "\"/>\n" +
                "\n" +
                "    <offline-allowed />\n" +
                "  </information>\n" +
                "  \n" +
                "  <security>\n" +
                "    <all-permissions />\n" +
                "  </security>\n" +
                "  \n" +
                "  <resources>\n" +
                "    <j2se version=\"" +
                "1.4+" +
                "\" />\n" +
                "    <jar href=\"" +
                jarFileName +
                "\" />\n" +
                "  </resources>\n" +
                " \n" +
                "  <application-desc main-class=\"" +
                mainClass +
                "\" />\n" +
                "</jnlp>\n";
        try {
            saveToDisk(jnlpFile, jnlpData);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    /**
     * Save the <code>data</code> out to the file called
     * <code>jnlpFile</code>
     *
     * @param jnlpFile
     * @param data
     * @throws IOException
     */
    private static void saveToDisk(File jnlpFile,
                                   String data)
            throws IOException {
        System.out.println("output to:" +
                jnlpFile +
                "\n" +
                data);
        FileWriter fw =
                new FileWriter(jnlpFile);
        fw.write(data);
        fw.write("\n");
        fw.close();
    }

    public static void testGetWebstartLocation() {
        In.message("found javaws at:" + WebStartLauncher.getWebstartLocation());
    }

}
