package rtf;

import futils.Futil;
import gui.run.DirectoryGui;
import gui.run.RunButton;

import javax.swing.*;
import java.awt.*;

/**
 * Copyright DocJava, inc. User: lyon Date: Aug
 * 18, 2004 Time: 9:40:41 AM
 */

public class DocUtilGui {
    private JFrame jf = new JFrame();
    private final DirectoryGui directoryGui =
            new DirectoryGui();


    public DocUtilGui() {
        getPanels();
    }

    private JPanel getPanels() {
        JPanel jp = new JPanel();
        jp.setLayout(new BorderLayout());
        jp.add(getOkCancelPanel(),
                BorderLayout.SOUTH);
        jp.add(
                directoryGui.getFilePanel(
                        "src directory"),
                BorderLayout.NORTH);
        return jp;
    }

    public static void main(String[] args) {
        Futil.setLookAndFeel();
        Futil.setSwing(true);
        DocUtilGui dug = new DocUtilGui();
        dug.testDocUtilBean();
    }

    public void testDocUtilBean() {

        Container c = jf.getContentPane();
        c.add(getPanels());
        jf.setSize(300, 300);
        jf.show();
    }

    private JPanel getOkCancelPanel() {
        JPanel jp = new JPanel();
        jp.add(new RunButton("[ok") {
            public void run() {
                jf.hide();
            }
        });
        jp.add(new RunButton("[Exit") {
            public void run() {
                jf.hide();
                System.exit(0);
            }
        });
        jp.setLayout(new FlowLayout());
        return jp;
    }

}
