package net.web;

import java.io.*;
import java.net.Socket;
import java.net.URL;

public class PortMapper {
    public static void main(String args[]) {

        new PortMapper(80);
    }

    public PortMapper(int port) {
        net.proxy.Proxy.setSoeProxy();
        try {
            java.net.ServerSocket ss
                    = new java.net.ServerSocket(port);
            while (true) {
                new PortMappingService(ss.accept());
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
    }
}

class PortMappingService implements
        Runnable {
    private Socket clientsSocket;
    private BufferedReader socketsBufferedReader;
    private OutputStream socketsOutputStream;

    PortMappingService(Socket _s) {

        clientsSocket = _s;
        try {
            socketsBufferedReader =
                    new BufferedReader(
                            new InputStreamReader(
                                    clientsSocket.getInputStream()));
            socketsOutputStream = clientsSocket.getOutputStream();
        } catch (IOException e) {
            e.printStackTrace();
        }
        Thread t = new Thread(this);
        t.start();
    }

    public void run() {
        try {
            String line =
                    socketsBufferedReader.readLine();
            java.util.StringTokenizer
                    st =
                    new java.util.StringTokenizer(
                            line);
            System.out.println(line);
            if (st.nextToken().equals("GET"))
                getABinaryUrl(st);

            socketsOutputStream.close();
            clientsSocket.close();
        } catch (Exception e) {
        }
    }

    public void getABinaryUrl(java.util.StringTokenizer st)
            throws FileNotFoundException,
            IOException {
        String urlName
                = st.nextToken();
        urlName = "http:/" + urlName;

        URL url = new URL(urlName);
        InputStream
                urlIs = url.openStream();
        byte b [] = new byte[1024];
        int numberRead = -1;
        while ((numberRead = urlIs.read(b)) > 0)
            socketsOutputStream.write(b);
    }
}
