package net.ssh.terminal;

import gui.ClosableJFrame;
import gui.run.RunMenu;
import gui.run.RunMenuBar;
import gui.run.RunMenuItem;
import net.scp.ScpBean;
import net.scp.ScpMain;
import net.ssh.sch.*;

import javax.swing.*;
import java.awt.*;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;

// Referenced classes of package com.jcraft.jcterm:
//            Sftp, EmulatorVT100, Term, Splash, 
//            Emulator

public class MainTerminal extends JPanel
        implements KeyListener, Runnable, Term {
    private ScpBean scpBean = null;

    public static void displayTerminal(ScpBean scpBean) {
        MainTerminal termPanel = new MainTerminal(scpBean);
        ClosableJFrame cf = new ClosableJFrame("Simple SSH");

        cf.setJMenuBar(termPanel.getJMenuBar());
        cf.setSize(termPanel.getSize());
        cf.getContentPane().add("Center", termPanel);
        cf.pack();
        termPanel.setVisible(true);
        cf.setVisible(true);
        cf.setResizable(true);
        int i = termPanel.getTermWidth();
        int j = termPanel.getTermHeight();
        i += cf.getWidth() - cf.getContentPane().getWidth();
        j += cf.getHeight() - cf.getContentPane().getHeight();
        cf.setSize(i, j);
        cf.setResizable(false);
        termPanel.setFrame(cf.getContentPane());
        termPanel.requestFocus();
    }



    public MainTerminal(ScpBean scpBean) {
        this.scpBean = scpBean;

        img = new BufferedImage(1, 1, 1);
        graphics =  img.getGraphics();
        graphics.setFont(font);
        FontMetrics fm = graphics.getFontMetrics();
        descent = ((FontMetrics) (fm)).getDescent();
        char_width = ((FontMetrics) (fm)).charWidth('@');
        char_height = ((FontMetrics) (fm)).getHeight() + line_space * 2;
        descent += line_space;
        img.flush();
        graphics.dispose();
        background = new BufferedImage(char_width, char_height, 1);
        Graphics g =  background.getGraphics();
        g.setColor(bground);
        g.fillRect(0, 0, char_width, char_height);
        g.dispose();
        img = new BufferedImage(getTermWidth(), getTermHeight(), 1);
        graphics = (Graphics2D) img.getGraphics();
        graphics.setFont(font);

        clear();
        cursor_graphics = img.getGraphics();
        cursor_graphics.setColor(fground);
        cursor_graphics.setXORMode(bground);

        setPreferredSize(
                new Dimension(getTermWidth(), getTermHeight()));
        setSize(getTermWidth(), getTermHeight());
        setFocusable(true);
        enableInputMethods(true);
        setFocusTraversalKeysEnabled(false);

    }

    public void setFrame(Component component) {
        term_area = component;
    }

    public void kick() {
        thread = new Thread(this);
        thread.start();
    }

    public void run() {
        JSch jsch = new JSch();
        while (thread != null) {
            try {
                int i = 22;

                try {
                    connectSession(jsch, i);
                } catch (Exception exception2) {
                    break;
                }

                if (mode == 0) {
                    Channel channel = session.openChannel("shell");

                    out = channel.getOutputStream();
                    in = channel.getInputStream();
                    channel.connect();
                }

                emulator = new EmulatorVT100(this, in);
                emulator.reset();
                emulator.start();
            } catch (Exception exception) {
            }
            break;
        }
        thread = null;
        if (session != null) {
            session.disconnect();
            session = null;
        }
        clear();
        redraw(0, 0, getTermWidth(), getTermHeight());
    }

    private void connectSession(JSch jsch, int i) throws JSchException {
        session = jsch.getSession(
                scpBean.getUser(), scpBean.getHost(), i);
        session.setProxy(proxy);
        session.setUserInfo(scpBean.getSimpleUserInfo());
        Properties properties = new Properties();
        if (compression == 0) {
            properties.put("compression.s2c", "none");
            properties.put("compression.c2s", "none");
        } else {
            properties.put("compression.s2c", "zlib,none");
            properties.put("compression.c2s", "zlib,none");
        }
        session.setConfig(properties);
        session.setTimeout(5000);
        session.connect();
        session.setTimeout(0);
    }

    public void paintComponent(Graphics g) {
        g.drawImage(img, 0, 0, term_area);
    }

    public void update(Graphics g) {
    }

    public void paint(Graphics g) {
        super.paint(g);
    }

    public void processKeyEvent(KeyEvent keyevent) {
        int i = keyevent.getID();
        if (i == 401)
            keyPressed(keyevent);
        else if (i != 402 && i == 400)
            keyTyped(keyevent);
        keyevent.consume();
    }

    public void keyPressed(KeyEvent keyevent) {
        int i = keyevent.getKeyCode();
        byte abyte0[] = null;
        switch (i) {
            case 16: // '\020'
            case 17: // '\021'
            case 18: // '\022'
            case 20: // '\024'
                return;

            case 10: // '\n'
                abyte0 = emulator.getCodeENTER();
                break;

            case 38: // '&'
                abyte0 = emulator.getCodeUP();
                break;

            case 40: // '('
                abyte0 = emulator.getCodeDOWN();
                break;

            case 39: // '\''
                abyte0 = emulator.getCodeRIGHT();
                break;

            case 37: // '%'
                abyte0 = emulator.getCodeLEFT();
                break;

            case 112: // 'p'
                abyte0 = emulator.getCodeF1();
                break;

            case 113: // 'q'
                abyte0 = emulator.getCodeF2();
                break;

            case 114: // 'r'
                abyte0 = emulator.getCodeF3();
                break;

            case 115: // 's'
                abyte0 = emulator.getCodeF4();
                break;

            case 116: // 't'
                abyte0 = emulator.getCodeF5();
                break;

            case 117: // 'u'
                abyte0 = emulator.getCodeF6();
                break;

            case 118: // 'v'
                abyte0 = emulator.getCodeF7();
                break;

            case 119: // 'w'
                abyte0 = emulator.getCodeF8();
                break;

            case 120: // 'x'
                abyte0 = emulator.getCodeF9();
                break;

            case 121: // 'y'
                abyte0 = emulator.getCodeF10();
                break;
        }
        if (abyte0 != null) {
            try {
                out.write(abyte0, 0, abyte0.length);
                out.flush();
            } catch (Exception exception) {
            }
            return;
        }
        char c = keyevent.getKeyChar();
        if ((c & 0xff00) == 0) {
            obuffer[0] = (byte) keyevent.getKeyChar();
            try {
                out.write(obuffer, 0, 1);
                out.flush();
            } catch (Exception exception1) {
            }
        }
    }

    public void keyTyped(KeyEvent keyevent) {
        char c = keyevent.getKeyChar();
        if ((c & 0xff00) != 0) {
            char ac[] = new char[1];
            ac[0] = c;
            try {
                byte abyte0[] = (new String(ac)).getBytes("EUC-JP");
                out.write(abyte0, 0, abyte0.length);
                out.flush();
            } catch (Exception exception) {
            }
        }
    }

    public int getTermWidth() {
        return char_width * term_width;
    }

    public int getTermHeight() {
        return char_height * term_height;
    }

    public int getCharWidth() {
        return char_width;
    }

    public int getCharHeight() {
        return char_height;
    }

    public int getColumnCount() {
        return term_width;
    }

    public int getRowCount() {
        return term_height;
    }

    public void clear() {
        graphics.setColor(bground);
        graphics.fillRect(0,
                0,
                char_width * term_width,
                char_height * term_height);
        graphics.setColor(fground);
    }

    public void setCursor(int i, int j) {
        x = i;
        y = j;
    }

    public void draw_cursor() {
        cursor_graphics.fillRect(x,
                y - char_height,
                char_width,
                char_height);
        term_area.repaint(x, y - char_height, char_width, char_height);
    }

    public void redraw(int i, int j, int k, int l) {
        term_area.repaint(i, j, k, l);
    }

    public void clear_area(int i, int j, int k, int l) {
        graphics.setColor(bground);
        graphics.fillRect(i, j, k - i, l - j);
        graphics.setColor(fground);
    }

    public void scroll_area(int i, int j, int k, int l, int i1, int j1) {
        graphics.copyArea(i, j, k, l, i1, j1);
    }

    public void drawBytes(byte abyte0[], int i, int j, int k, int l) {
        graphics.drawBytes(abyte0, i, j, k, l - descent);
    }

    public void drawString(String s, int i, int j) {
        graphics.drawString(s, i, j - descent);
    }

    public void beep() {
        Toolkit.getDefaultToolkit().beep();
    }

    public void keyReleased(KeyEvent keyevent) {
    }

    public void setProxyHttp(String s, int i) {
        proxy_http_host = s;
        proxy_http_port = i;
        if (proxy_http_host != null && proxy_http_port != 0)
            proxy = new ProxyHTTP(proxy_http_host, proxy_http_port);
        else
            proxy = null;
    }

    public String getProxyHttpHost() {
        return proxy_http_host;
    }

    public int getProxyHttpPort() {
        return proxy_http_port;
    }

    public void setProxySOCKS5(String s, int i) {
        proxy_socks5_host = s;
        proxy_socks5_port = i;
        if (proxy_socks5_host != null && proxy_socks5_port != 0)
            proxy = new ProxySOCKS5(proxy_socks5_host, proxy_socks5_port);
        else
            proxy = null;
    }

    public String getProxySOCKS5Host() {
        return proxy_socks5_host;
    }

    public int getProxySOCKS5Port() {
        return proxy_socks5_port;
    }



    public void setLineSpace(int i) {
        line_space = i;
    }


    public void setCompression(int i) {
        if (i < 0 || 9 < i) {
            return;
        } else {
            compression = i;
            return;
        }
    }

    public int getCompression() {
        return compression;
    }



    public void openSession() {
        kick();
    }

    public void setPortForwardingL(int i, String s, int j) {
        try {
            session.setPortForwardingL(i, s, j);
        } catch (JSchException jschexception) {
        }
    }

    public void setPortForwardingR(int i, String s, int j) {
        try {
            session.setPortForwardingR(i, s, j);
        } catch (JSchException jschexception) {
        }
    }

    public void openShell() {
        mode = 0;
        openSession();
    }

    public JMenuBar getJMenuBar() {
        RunMenuBar rmb = new RunMenuBar();
        RunMenu rm = new RunMenu("[File");
        rm.add(new RunMenuItem("Open SHELL Session...") {
            public void run() {
                openShell();
            }
        });
        rm.add(new RunMenuItem("upload file") {
            public void run() {
                ScpMain.main(null);
            }
        });
        rm.add(new RunMenuItem("Quit") {
            public void run() {
                quit();
            }
        });

        rmb.add(rm);
        return rmb;
    }


    public void quit() {
        thread = null;
        if (session != null) {
            session.disconnect();
            session = null;
        }
        System.exit(0);
    }

    public void setFGround(Object obj) {
        if (obj instanceof String)
            fground = Color.getColor((String) obj);
        if (obj instanceof Color)
            fground = (Color) obj;
        graphics.setColor(fground);
    }

    public void setBGround(Object obj) {
        if (obj instanceof String)
            bground = Color.getColor((String) obj);
        if (obj instanceof Color)
            bground = (Color) obj;
        Graphics2D graphics2d = (Graphics2D) background.getGraphics();
        graphics2d.setColor(bground);
        graphics2d.fillRect(0, 0, char_width, char_height);
        graphics2d.dispose();
    }

    public Object getFGround() {
        return fground;
    }

    public Object getBGround() {
        return bground;
    }

    static String COPYRIGHT = "JCTerm 0.0.6\n" +
            "Copyright (C) 2002-2004 ymnk<ymnk@jcraft.com>, JCraft,Inc.\n" +

            "This software is licensed under GNU LGPL.";
    private int mode=0;
    private OutputStream out;
    private InputStream in;
    private BufferedImage img;
    private BufferedImage background;
    private Graphics cursor_graphics;
    private Graphics graphics;
    private Color bground = Color.white;
    private Color fground = Color.black;
    private Component term_area = this;
    private Font font=Font.decode("Monospaced-14");
    private int term_width = 80;
    private int term_height = 24;
    private int x=0;
    private int y=0;
    private int descent=0;
    private int char_width;
    private int char_height;
    private String proxy_http_host=null;
    private int proxy_http_port=0;
    private String proxy_socks5_host=null;
    private int proxy_socks5_port=0;
    private Session session=null;
    private Proxy proxy=null;
    private int line_space=-2;
    private int compression=0;
    private Thread thread=null;
    private Emulator emulator=null;
    byte obuffer[]=new byte[3];

}
