package net.ssh.terminal;


import java.io.IOException;
import java.io.InputStream;

// Referenced classes of package com.jcraft.jcterm:
//            Term

public abstract class Emulator {

    public Emulator(Term term1,
                    InputStream inputstream) {
        term = null;
        in = null;
        buf = new byte[1024];
        bufs = 0;
        buflen = 0;
        term = term1;
        in = inputstream;
    }

    public abstract void start();

    public abstract byte[] getCodeENTER();

    public abstract byte[] getCodeUP();

    public abstract byte[] getCodeDOWN();

    public abstract byte[] getCodeRIGHT();

    public abstract byte[] getCodeLEFT();

    public abstract byte[] getCodeF1();

    public abstract byte[] getCodeF2();

    public abstract byte[] getCodeF3();

    public abstract byte[] getCodeF4();

    public abstract byte[] getCodeF5();

    public abstract byte[] getCodeF6();

    public abstract byte[] getCodeF7();

    public abstract byte[] getCodeF8();

    public abstract byte[] getCodeF9();

    public abstract byte[] getCodeF10();

    public abstract void reset();

    byte getChar()
            throws IOException {
        if (buflen == 0)
            fillBuf();
        buflen--;
        return buf[bufs++];
    }

    void fillBuf()
            throws IOException {
        buflen = bufs = 0;
        buflen = in.read(buf, bufs, buf.length - bufs);
        if (buflen <= 0) {
            buflen = 0;
            throw new IOException("fillBuf");
        } else {
            return;
        }
    }

    void pushChar(byte byte0)
            throws IOException {
        buflen++;
        buf[--bufs] = byte0;
    }

    int getASCII(int i)
            throws IOException {
        if (buflen == 0)
            fillBuf();
        if (i > buflen)
            i = buflen;
        int j = i;
        while (i > 0) {
            byte byte0 = buf[bufs++];
            if (32 <= byte0 && byte0 <= 127) {
                buflen--;
                i--;
                continue;
            }
            bufs--;
            break;
        }
        return j - i;
    }

    Term term;
    InputStream in;
    byte buf[];
    int bufs;
    int buflen;
}
