package net.server.servlets;


/**
 * The ReviewForm class extends the functionality of the
 * HtmlPage class. This class is employed to create a specific
 * type of HTML page, the Review Form.
 *
 * @author Robert Lysik
 * @version 1.00
 */
public class ReviewForm extends net.server.servlets.HtmlPage {
    private net.server.servlets.HtmlTable table;

    /**
     * This is the default constructor for the ReviewForm class.
     * The parent class, HtmlPage, constructor is called with
     * the title of the page to be created.
     */
    public ReviewForm(String courseId,
                      String sectionId,
                      Course course,
                      Student[] studentArray) {
        // Call the parent class with the title string
        super("Competency-based Review Form");

        String[] studentNameArray = new String[studentArray.length];

        for (int index = 0; index < studentArray.length; index++)
            studentNameArray[index] = studentArray[index].getFullName();

        // The table headings to display
        String colHeadings[] = {"Student Name",
                                "Analytical Skills",
                                "Communication Skills",
                                "Creative Problem Solving",
                                "Life-long Learning",
                                "Project Management",
                                "Research Skills",
                                "System Thinking",
                                "Teamwork"};

        createTable(studentNameArray, colHeadings);

        addHeadline(1, "Form C: Competency-based Review Form " +
                "for Basic Knowledge, Skills and Abilities");
        addBreak();
        addText("Complete for all students in your " +
                "class using a scale from 1 to 5");
        addBreak();
        startForm("get",
                "http://localhost:8080/examples/servlet/FormProcessorServlet");
        addHeadline(2, "Course Number & Name ");
        addText(courseId + " section: " + sectionId);
        addHeadline(2, "Instructor ");
        addText(course.getInstructor());
        addHeadline(2, "Term ");
        addText(course.getTerm());
        addBreak();

        addText(table.getHtml());

        // Hidden input controls are inserted into the HTML
        // page so that data can be returned. This information includes
        // column and row headings, the number of rows and columns,
        // and a flag indicating whether or not the form has
        // been submitted.
        for (int rowIndex = 0; rowIndex < studentArray.length; rowIndex++)
            addHidden("student" + rowIndex, studentArray[rowIndex].getFullName());

        for (int rowIndex = 0; rowIndex < studentArray.length; rowIndex++)
            addHidden("recordnum" + rowIndex, "" + studentArray[rowIndex].getStudentRecordNumber());

        for (int colIndex = 0; colIndex < colHeadings.length; colIndex++)
            addHidden("heading" + colIndex, colHeadings[colIndex]);

        addHidden("rows", "" + studentArray.length);
        addHidden("cols", "" + colHeadings.length);
        addHidden("course", courseId);
        addHidden("section", sectionId);
        addHidden("instructor", course.getInstructor());
        addHidden("term", course.getTerm());
        addHidden("year", course.getYear());
        addHidden("status", "evaluation_complete");

        addSubmit("Submit Form Data");

        endForm();
    }

    private void createTable(String students[],
                             String[] colHeadings) {
        int colIndex = 0,
                rowIndex = 0;

        String select = new String();

        // The values for the drop down list box
        String values[] = {"1", "2", "3", "4", "5"};

        // The text to be displayed in the drop down list box


        table = new net.server.servlets.HtmlTable(students.length + 1,
                colHeadings.length, 1);

        // Populate the table with the headings
        for (colIndex = 0; colIndex < colHeadings.length; colIndex++)
            table.setElement(0, colIndex, colHeadings[colIndex]);

        // Populate the table with the students' names
        for (rowIndex = 0; rowIndex < students.length; rowIndex++)
            table.setElement(rowIndex + 1, 0, students[rowIndex]);

        // For each element in the table grid which is not a heading or
        // a student name, insert a drop down list box with five
        // selectable values.
        for (rowIndex = 1; rowIndex <= students.length; rowIndex++)
            for (colIndex = 1; colIndex < colHeadings.length; colIndex++) {
                select = "r" + rowIndex + "c" + colIndex;
                table.setElement(rowIndex,
                        colIndex,
                        getSelect(select, "1", values, values));
            }

    }
}
