package net.server.servlets;


/**
 *  LoginHtml Class
 */

public class LoginHtml {

    private final String header =
            Html.getImage(Html.quote("../Images/logo.jpg"), "center")
            + Html.getBreak();

    private String bodyDetail[][] = new String[2][2];

    private String nextActionURL;

    private final String title = "Login";
    private final String formName = "LoginForm";
    private final String formMethod = "GET";

    /**
     * Sets the next action URL
     */

    public void setNextActionURL(String _nextActionURL) {
        System.out.println("Then next action from setNextAction is " + _nextActionURL);
        nextActionURL = _nextActionURL;
    }

    /**
     * getCommandSubmit Method
     *
     * @return	    String
     */

    private String getCommandSubmit() {

        String commands = Html.getSubmitButton("Login")
                + Html.getResetButton();

        System.out.println("The getCommandSubmit is " + commands);

        return Html.getTable(
                Html.getRow(Html.getTd(commands)),
                "Center", "0", "30%", "Nowrap");

    }

    /**
     * getHeader  Method
     *
     * @return	  String
     */

    private String getHeader() {

        return Html.getTable(Html.getRow(Html.getTd(header)),
                "Center", "0", "100%", "Nowrap");

    }

    /**
     * getBodyDetail Method
     *
     * @return	   String
     */

    private String getBodyDetail() {
        bodyDetail[0][0] = "User ID :";
        bodyDetail[0][1] = Html.getTextField("txtUserId", "", 10);
        bodyDetail[1][0] = "Password:";
        bodyDetail[1][1] = Html.getPassField("txtPassword", "", 10);

        return Html.getTable(getLoginSheet(bodyDetail),
                "Center", "0", "40%", "Nowrap");
    }

    /**
     * getLoginSheet Method
     *
     * @return	   String
     */

    private String getLoginSheet(String data[][]) {
        String str = "";

        for (int i = 0; i < data.length; i++) {
            str = str + "<tr>";
            for (int j = 0; j < data[i].length; j++) {
                str = str + Html.getTd(data[i][j]);
            }
        }

        str = str + "</tr>\n";

        return str;
    }

    /**
     * getErrorMessage	 Method
     *
     * @return	  	     String
     */

    private String getErrorMessage(String errorMessage) {

        String err = Html.getBold(Html.getFont(errorMessage, "+2"));

        return Html.getTable(Html.getRow(Html.getTd(err),
                "Center"), "0", "100%", "Nowrap");

    }

    /**
     * Returns the Login Page
     *
     * @return	    String
     */

    public String getLoginPage() {
        return
                Html.getHtml(
                        Html.getHead(Html.getTitle(title))
                + Html.getBody(
                        getHeader()
                + Html.getForm(formName, nextActionURL, formMethod,
                        Html.getBreak()
                + Html.getHiddenField("txtNextAction", "FormC")
                + getBodyDetail()
                + Html.getBreak()
                + getCommandSubmit()
                )
                )
                );
    }

    /**
     * Returns the Error Login Page
     *
     * @return	  String
     */

    public String getLoginErrorPage(String errorMessage) {


        return
                Html.getHtml(
                        Html.getHead(Html.getTitle(title + " " + "Error")) +
                Html.getBody(
                        getHeader()
                + Html.getForm(formName, nextActionURL, formMethod,
                        getErrorMessage(errorMessage)
                + Html.getHiddenField("txtNextAction", "FormC")
                + Html.getBreak()
                + getBodyDetail()
                + Html.getBreak()
                + getCommandSubmit()
                + Html.getBreak())
                )
                );
    }
}
