package net.server.servlets;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.Vector;

/**
 *  CsvLineConsumer Class
 */

public class CsvLineConsumer implements LineConsumer {

    /**
     * Components
     */

    private BufferedReader br;
    private Vector vData = new Vector();;
    private int[] column;


    /**
     * CsvLineConsumer() Constructor
     */

    public CsvLineConsumer(BufferedReader _br, int[] _column) {
        br = _br;
        column = _column;

        readBufferedReader();
    }


    /**
     * Returns CSV Data
     *
     * @return 			void
     */

    public Vector getVData() {
        return vData;

    }


    /**
     * readBufferedReader   Method
     *
     */

    private void readBufferedReader() {

        String line = null;

        try {
            line = br.readLine(); // to get the column names

            while ((line = br.readLine()) != null) {
                setVectorDataElement(line);
            }
        } catch (IOException e) {
        }

        FileUtil.close(br);

    }


    /**
     * setVectorDataElement   Method
     *
     */

    private void setVectorDataElement(String line) {

        String sData[] = getValues(line, column);
        vData.addElement(sData);
    }


    /**
     * Return an array of columns
     *
     * @return 	String[]
     */

    public String[] getValues(String s, int column[]) {
        CsvParser csvData = new CsvParser(s);

        String strArray[] = csvData.getTokens();
        String selArray[] = new String[column.length];

        for (int i = 0; i < column.length; i++) {
            selArray[i] = strArray[column[i]];
        }


        return selArray;
    }

}
