package net.scp;


import futils.Futil;
import gui.ClosableJFrame;
import gui.In;
import gui.dialogs.LabeledItemPanel;
import gui.dialogs.ModalDialog;
import gui.run.*;
import net.ssh.terminal.MainTerminal;

import javax.swing.*;
import java.awt.*;
import java.beans.PropertyChangeSupport;
import java.io.File;

/**
 * net.scp.ScpDialog
 */
public class ScpMain extends ModalDialog {

    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private ScpBean scpBean = ScpBean.restore();
    private LabeledItemPanel c = new LabeledItemPanel();

    public ScpMain() {

        setTitle("Scp Dialog");
        c.addItem("host", new RunTextField(scpBean.getHost(),20) {
            public void run() {
                scpBean.setHost(getText());
            }
        });
        final RunTextField localFileTextField = getLocalFileTextField();
        c.addItem("localFile", localFileTextField);
        c.addItem("setLocalFile", new RunButton("browse") {
            public void run() {
                File f = Futil.getReadFile("select local file");
                localFileTextField.setText(f.getAbsolutePath());
                scpBean.setLocalFile(f.getAbsolutePath());

            }
        });
        c.addItem("remoteFile", new RunTextField(scpBean.getRemoteFile(),20) {
            public void run() {
                scpBean.setRemoteFile(getText());
            }
        });
        c.addItem("user", new RunTextField(scpBean.getUser(),20) {
            public void run() {
                scpBean.setUser(getText());
            }
        });
        c.addItem("password", new RunPasswordField(scpBean.getPassword(),20) {
            public void run() {
                scpBean.setPassword(getPasswordString());
            }
        });
        c.addItem("protocol", new protocolCheckbox());
        c.addItem("launch ssh", new RunButton("ssh terminal"){
            public void run(){
                launchTerminal();
            }
        });

        c.setBorder(BorderFactory.createEtchedBorder());

        setContentPane(c);
    }

    private void launchTerminal() {
        ClosableJFrame cf = new ClosableJFrame();
        MainTerminal termPanel = new MainTerminal(scpBean);
        final JMenuBar jMenuBar = termPanel.getJMenuBar();
        cf.setJMenuBar(jMenuBar);
        cf.setSize(termPanel.getTermWidth(), termPanel.getTermHeight());
        Container c = cf.getContentPane();
        c.add(termPanel);
        cf.pack();
        termPanel.setVisible(true);
        cf.setVisible(true);
        cf.setResizable(true);
        int i = termPanel.getTermWidth();
        int j = termPanel.getTermHeight();
        i += getWidth() - getContentPane().getWidth();
        j += getHeight() - getContentPane().getHeight();
        cf.setSize(i, j);
        cf.setResizable(false);
        setVisible(false);
        termPanel.openSession();
    }

    private RunTextField getLocalFileTextField() {
        return new RunTextField(
                scpBean.getLocalFile(),20) {
            public void run() {
                scpBean.setLocalFile(getText());
            }
        };
    }

    /**
     * This method gets the values of the panel entry fields.
     *
     * @return an object containing the Customer data
     */
    public ScpBean getData() {
        return scpBean;
    }
    public void addScpChangeEventListener(ScpModelChangeEventListener l){
        pcs.addPropertyChangeListener(l);
    }
    public void okPressed(){
        if (isValidData()){
            new RunJob(1,false,1,false,Thread.MIN_PRIORITY){
                public void run(){
                    processOk();
                }
            };
        }
        else
            debugData();
    }

    private void processOk() {
        //setVisible(false);
        scpBean.save();
        final ScpModelChangeEvent evt = new ScpModelChangeEvent(this,scpBean);
        pcs.firePropertyChange(evt);

        scpBean.upload();
        if (In.getBoolean("transfer done, exit?")) System.exit(0);
        //setVisible(true);

    }

    public void debugData() {
        In.message("data not valid! Model="+scpBean);

    }


    /**
     * This method checks that the data entered is valid.
     *
     * @return <code>true</code> if the data is valid, otherwise
     *         <code>false</code>
     */
    protected boolean isValidData() {

        return scpBean.isValidData();
    }

    public static void main(String[] args) {
        ScpMain dialog = new ScpMain();
        dialog.pack();
        dialog.show();
    }

    private class protocolCheckbox extends RunCheckBox {
        public protocolCheckbox() {
            super(" scp", scpBean.isScp());
            updateLabel();
        }

        public void run() {
            scpBean.setScp(isSelected());
            updateLabel();
        }

        private void updateLabel() {
            if (isSelected())
                setText(" scp");
            else setText("sftp");
        }
    }
}