package net.rmi.simpleExample;

import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;

public class RmiHelloClient {
    private String rmiUrl = null;
    private RemoteHello rh = null;

    public RmiHelloClient(String location) {
        rmiUrl = location;
        try {
            rh = lookupDelgate();
        } catch (NotBoundException e) {
            e.printStackTrace();
        } catch (java.net.MalformedURLException e) {
            e.printStackTrace();
        } catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    private RemoteHello lookupDelgate()
            throws NotBoundException,
            java.net.MalformedURLException,
            RemoteException {
        RemoteHello rh = (RemoteHello)
                Naming.lookup(rmiUrl);
        return rh;
    }

    public static void main(String args[]) {
        try {
            RmiHelloClient rhc =
                    new RmiHelloClient(
                            "rmi://localhost/RemoteHello");
            rhc.testGetMsg();
        } catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    private void testGetMsg()
            throws
            RemoteException {
        System.out.println(rh.getMsg());
    }
}
