package net.multicast;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketException;

public class McastUtil {
    private int port = 2435;
    private InetAddress inetAddress;
    private MulticastSocket mcastSocket;
    byte buf[] = new byte[100000];


    public McastUtil(int port) {
        try {
            this.port = port;
            inetAddress = Utils.getMcastAddress();
            mcastSocket =
                    Utils.getMulticastSocket(port, inetAddress);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setLoopBack(boolean b) {
        try {
            mcastSocket.setLoopbackMode(b);
        } catch (SocketException e) {
            e.printStackTrace();
        }
    }

    /**
     * Invocation blocks the callers' thread of execution,
     * so invoke inside of another thread, in a loop.
     *
     * @return
     * @throws IOException
     */
    public byte[] getBytes() throws IOException {
        DatagramPacket recv = new DatagramPacket(buf, buf.length);
        mcastSocket.receive(recv);
        buf = recv.getData();
        byte b[] = new byte[recv.getLength()];
        for (int i=0; i < b.length; i++)
            b[i] = buf[i];
        return b;
    }

    public void sendBytes(byte b[]) throws IOException {
        DatagramPacket dp = new DatagramPacket(b,
                b.length,
                inetAddress,
                port);
        mcastSocket.send(dp);
    }

    public int getPort() {
        return port;
    }

    public InetAddress getInetAddress() {
        return inetAddress;
    }

    public MulticastSocket getMcastSocket() {
        return mcastSocket;
    }
}
