package net.mail.swing;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;

public class Smtp implements Runnable {

  String recipientEmail = null;
  String senderEmail = null;
  String serverHostName = null;
  String message = null;

  int smtpPort = 25;

  Socket socket;
  PrintWriter pw;
  BufferedReader br;
  InetAddress ia;
  InetAddress lina;


  Thread thread = new Thread(this);

  public void emailLyon(String msg) {
    email(msg,
          "192.168.1.95",
          "lyon@docjava.com",
          "lyon@docjava.com");
  }

  public void email(String msg,
                    String serverHostName,
                    String recipientEmail,
                    String senderEmail) {
    setSenderEmail(senderEmail);
    setRecipientEmail(recipientEmail);
    setMailServerHostName(serverHostName);
    setMessage(msg);
    thread.start();
  }

  public void start() {
    thread.start();
  }


  public void run() {
    try {
      send();
    } catch (IOException e) {
      e.printStackTrace();
    }
  }

  public void send() throws IOException {
    socket = new Socket(serverHostName, smtpPort);
    try {
      ia = socket.getInetAddress();
      lina = ia.getLocalHost();

      pw = new PrintWriter(socket.getOutputStream());
      br = new BufferedReader(
          new InputStreamReader(
              socket.getInputStream()
          )
      );
      sendline("HELO " + lina.toString());
      sendline("MAIL FROM:" + senderEmail);
      sendline("RCPT TO:" + recipientEmail);
      sendline("DATA");
      sendline(message);
      sendline(".");


    } catch (Exception c) {
      socket.close();
      System.out.println(
          "Error; message send failed:\n "
          + c.getMessage());
    }
    socket.close();
  }

  void sendline(String data) throws IOException {
    pw.println(data);
    pw.flush();
    String s = br.readLine();
    System.out.println("sendline in:" + s);
  }

  public void setMessage(String msg) {
    message = msg;
  }

  public void setSenderEmail(String email) {
    senderEmail = email;
  }

  public void setRecipientEmail(String email) {
    recipientEmail = email;
  }

  public void setMailServerHostName(String host) {
    serverHostName = host;
  }

  public static void main(String args[]) {
    Smtp sm = new Smtp();
    sm.emailLyon("This is a test!!");
    System.out.println("Thread was started to send an email");
  }


}