package net.compute;

import classUtils.putils.ClassPathUtils;
import futils.Futil;
import gui.In;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

/**
 * Created by
 * User: lyon
 * Date: Aug 19, 2003
 * Time: 9:22:07 AM
 *
 */

/**
 * Defines a Class Loader that knows how to read a class
 * from the local file system.
 */
public class LocalClassLoader extends java.lang.ClassLoader {
    private String directory;

    public LocalClassLoader(String dir) {
        directory = dir;
    }

    // todo test this
    public Class loadClassFromFile(String className, boolean resolve)
            throws ClassNotFoundException, FileNotFoundException {
        File target =
                new File(directory
                + className.replace('.', '/')
                + ".class");
        if (!target.exists()) throw new java.io.FileNotFoundException();
        try {
            return
                    loadClassFromFile(target,
                            className,
                            resolve);
        } catch (IOException e) {
            System.out.println("Aborting read: "
                    + e.toString()
                    + " in LocalClassLoader.");
            throw new ClassNotFoundException();
        }
    }
    public static void main(String[] args) {
        testLoadClassFromFile();
    }
    public static void testLoadClassFromFile(){
        LocalClassLoader lcl = new LocalClassLoader("");
        do {
            try {
                File f = Futil.getReadFile("select a class File");
                Class c = lcl.loadClassFromFile(f,true);
                In.message("loaded class:"+c.getName());
            } catch (IOException e) {
                In.message(e);

            }
        }while(In.getBoolean("again?"));
    }

    // todo test this
    public Class loadClassFromFile(File f,
                                   boolean resolve)
            throws IOException {
        String cn = ClassPathUtils.getClassName(f);
        In.message("loading class:"+cn);
        return loadClassFromFile(f,cn,true);
    }
    // todo test this
    public Class loadClassFromFile(File fileTarget, String className,
                                   boolean resolve)
            throws IOException {
        byte buffer [] = Futil.getBytes(fileTarget);
        int bytecount = buffer.length;
        In.message("Defining class from bytecodes");
        Class c = defineClass(className, buffer, 0, (int) bytecount);
        In.message("defined class");
        if (resolve) resolveClass(c);
        System.out.println("[Loaded " + className
                + " from " + fileTarget
                + " (" + bytecount + " bytes)]");
        return c;
    }

    public static void doIt(String argv[]) {
        try {
            if (argv.length < 1) {
                System.out.println("Usage: java Test ");
                return;
            }
            String target = argv[0];
            DelegatingLoader loader =
                    new DelegatingLoader("ersatz/");
            Class c = loader.loadClass(target, true);
            Object[] arg = {};
            Class[] argClass = {};
            // invoke the main method on the given class
            // with the argument list.
            c.getMethod("main", argClass).invoke(null, arg);
        } catch (Exception e) {
            System.out.println("Error " + e.toString()
                    + " in Test.doIt.");
        }
    }
}

