package net.compute;

/**
  * Created by
  * User: lyon
  * Date: Sep 3, 2003
  * Time: 11:17:45 AM
  *
  */

import java.io.*;

public class GreeterLoader extends ClassLoader {

     // basePath gives the path to which this class
     // loader appends "/.class" to get the
     // full path name of the class file to load
     private String basePath;

     public GreeterLoader(String basePath) {

         this.basePath = basePath;
     }

     public synchronized Class loadClass(String className,
         boolean resolveIt) throws ClassNotFoundException {

         Class result;
         byte classData[];

         // Check the loaded class cache
         result = findLoadedClass(className);
         if (result != null) {
             // Return a cached class
             return result;
         }

         // If Spoofed, don't delegate
         if (className.compareTo("Spoofed") != 0) {

             // Check with the system class loader
             try {
                 result = super.findSystemClass(className);
                 // Return a system class
                 return result;
             }
             catch (ClassNotFoundException e) {
             }
         }

         // Don't attempt to load a system file except through
         // the primordial class loader
         if (className.startsWith("java.")) {
             throw new ClassNotFoundException();
         }

         // Try to load it from the basePath directory.
         classData = getTypeFromBasePath(className);
         if (classData == null) {
             System.out.println("GCL - Can't load class: "
                 + className);
             throw new ClassNotFoundException();
         }

         // Parse it
         result = defineClass(className, classData, 0,
             classData.length);
         if (result == null) {
             System.out.println("GCL - Class format error: "
                 + className);
             throw new ClassFormatError();
         }

         if (resolveIt) {
             resolveClass(result);
         }

         // Return class from basePath directory
         return result;
     }

     private byte[] getTypeFromBasePath(String typeName) {

         FileInputStream fis;
         String fileName = basePath + File.separatorChar
             + typeName.replace('.', File.separatorChar)
             + ".class";

         try {
             fis = new FileInputStream(fileName);
         }
         catch (FileNotFoundException e) {
             return null;
         }

         BufferedInputStream bis = new BufferedInputStream(fis);

         ByteArrayOutputStream out = new ByteArrayOutputStream();

         try {
             int c = bis.read();
             while (c != -1) {
                 out.write(c);
                 c = bis.read();
             }
         }
         catch (IOException e) {
             return null;
         }

         return out.toByteArray();
     }
      // Arguments to this application:
     //     args[0] - path name of directory in which class files
     //               for greeters are stored
     //     args[1], args[2], ... - class names of greeters to load
     //               and invoke the greet() method on.
     //
     // All greeters must implement the com.artima.greeter.Greeter
     // interface.
     //
     static public void main(String[] args) {

         if (args.length <= 1) {
             System.out.println(
                 "Enter base path and greeter class names as args.");
             return;
         }

         for (int i = 1; i < args.length; ++i) {
             try {

                 GreeterLoader gcl =
                     new GreeterLoader(args[0]);

                 // Load the greeter specified on the command line
                 Class c = gcl.loadClass(args[i]);

                 // Instantiate it into a greeter object
                 Object o = c.newInstance();

                 // Cast the Object ref to the Greeter interface type
                 // so greet() can be invoked on it
                 Runnable greeter = (Runnable) o;

                 // Greet the world in this greeter's special way
                 greeter.run();

                 // Forget the class loader object, Class
                 // instance, and greeter object
                 gcl = null;
                 c = null;
                 o = null;
                 greeter = null;

                 // At this point, the types loaded through the
                 // GreeterClassLoader object created at the top of
                 // this for loop are unreferenced and can be unloaded
                 // by the virtual machine.
             }
             catch (Exception e) {
                 e.printStackTrace();
             }
         }
     }
}
