package j3d.utils;

/**
 * Created by IntelliJ IDEA.
 * User: jgervasio
 * Date: Feb 23, 2004
 * Time: 12:11:58 PM
 * To change this template use Options | File Templates.
 */


import com.sun.j3d.utils.applet.MainFrame;
import com.sun.j3d.utils.behaviors.keyboard.KeyNavigatorBehavior;
import com.sun.j3d.utils.geometry.Cylinder;
import com.sun.j3d.utils.geometry.Primitive;
import com.sun.j3d.utils.geometry.Sphere;
import com.sun.j3d.utils.universe.PlatformGeometry;
import j3d.examples.GunController;

import javax.media.j3d.*;
import javax.vecmath.*;
import java.applet.Applet;
import java.awt.*;


//   BillboardApp renders a simple landscape with billboard animated trees
  // j3d.cr325.LevitownDoomKeyboard
public class DoomKeyboard extends Applet {

    Alpha joeAlpha = new Alpha(-1, 0, 0, 3000, 0, 0);
    protected BoundingSphere bounds
            = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 200.0);
    Alpha ballAlpha = new Alpha(1, 0, 0, 500, 0, 0);
    PositionInterpolator bulletPositionInterpolator = null;
    TransformGroup gunTransformGroup = Gutils.getTransformGroup();
    TransformGroup bulletTransformGroup = Gutils.getTransformGroup();
    TransformGroup targetTransformGroup = Gutils.getTransformGroup();
    public Switch joeSwitch = getJoeSwitch();


    public BranchGroup getSceneBranchGroup(TransformGroup viewTransformGroup) {

        BranchGroup rootBranchGroup = new BranchGroup();

        Vector3f translate = new Vector3f();
        Transform3D T3D = new Transform3D();

        BoundingSphere bs
                = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 20000);
        rootBranchGroup.addChild(ShapeCollection.getLand());

        addTrees(translate, T3D, bs, rootBranchGroup);
        addHouses(translate, T3D, bs, rootBranchGroup);

        raiseViewAboveGround(translate, T3D, viewTransformGroup);
        addKeyboardNavigation(viewTransformGroup, rootBranchGroup);

        //BranchGroup target = new BranchGroup();
        //target = Target.getTargetGroup();
        //textureSphere.addChild(target);

        BranchGroup textureSphere = new BranchGroup();
        textureSphere.addChild(getJoeGroup());
        rootBranchGroup.addChild(textureSphere);


        Matrix3d viewTilt = new Matrix3d();
        viewTilt.rotX(Math.PI / -6);
        T3D.set(viewTilt, new Vector3d(0.0, 10.0, 10.0), 1.0);

        TransformGroup viewXfmGroup = new TransformGroup(T3D);
        //ViewPlatform myViewPlatform = new ViewPlatform();
        PhysicalBody myBody = new PhysicalBody();
        PhysicalEnvironment myEnvironment = new PhysicalEnvironment();
        //viewXfmGroup.addChild(myViewPlatform);
        rootBranchGroup.addChild(viewXfmGroup);

        view = new View();
        //myView.addCanvas3D(Utils.getCanvas3D(this));
        //myView.attachViewPlatform(myViewPlatform);
        view.setPhysicalBody(myBody);
        view.setPhysicalEnvironment(myEnvironment);
        gc.setView(view);
        rootBranchGroup.compile();
        return rootBranchGroup;
    } // end of CreateSceneGraph method of BillboardApp
    KeyBehavior keyNavBeh = null;


    public void addKeyboardNavigation(TransformGroup transformGroup, BranchGroup bg) {
        keyNavBeh = new KeyBehavior(transformGroup);
        keyNavBeh.setSchedulingBounds(new BoundingSphere(new Point3d(), 10000.0));

        BranchGroup gunBranchGroup = new BranchGroup();
        gunBranchGroup = buildGun(transformGroup);
        gc.setGun(gunBranchGroup);
        bg.addChild(keyNavBeh);

        bg.addChild(gunBranchGroup);
    }

    public void addKeyboardNavigation2(TransformGroup tg, BranchGroup bg) {
        KeyNavigatorBehavior keyNavBeh = new KeyNavigatorBehavior(tg);
        keyNavBeh.setSchedulingBounds(new BoundingSphere(new Point3d(), 10000.0));

        BranchGroup textureGun = new BranchGroup();
        textureGun = buildGun(tg);
        gc.setGun(textureGun);
        bg.addChild(textureGun);
        bg.addChild(keyNavBeh);
    }


    private void raiseViewAboveGround(Vector3f translate, Transform3D t3D, TransformGroup tg) {
        translate.set(0.0f, 0.3f, 0.0f);
        t3D.setTranslation(translate);
        tg.setTransform(t3D);
    }

    private void addHouses(Vector3f translate,
                           Transform3D t3D,
                           BoundingSphere bSphere,
                           BranchGroup bg) {
        SharedGroup share = new SharedGroup();

        share.addChild(ShapeCollection.getHouses());

        float position[][] = {{0.0f, 0f, -2.0f},
                              {3.0f, 0f, 0.0f},
                              {3.0f, 0f, 4.0f},
                              {4.0f, 0f, -8.0f},
                              {6.0f, 0f, -25.0f},
                              {-6.0f, 0f, 25.0f},
                              {-6.0f, 0f, 15.0f},
                              {6.0f, 0f, 1.0f}};

        placeStuff(position, translate, t3D, bSphere, bg, share);
    }

    private void addTrees(Vector3f translate,
                          Transform3D t3D,
                          BoundingSphere bSphere,
                          BranchGroup bg) {
        SharedGroup share = new SharedGroup();
        share.addChild(ShapeCollection.getTrees());

        float position[][] = {{0.0f, 0f, -3.0f},
                              {6.0f, 0f, 0.0f},
                              {6.0f, 0f, 6.0f},
                              {3.0f, 0f, -10.0f},
                              {13.0f, 0f, -30.0f},
                              {-13.0f, 0f, 30.0f},
                              {-13.0f, 0f, 23.0f},
                              {13.0f, 0f, 3.0f}};

        placeStuff(position, translate, t3D, bSphere, bg, share);
    }

    private void placeStuff(float[][] position,
                            Vector3f translateV3f,
                            Transform3D transform3D,
                            BoundingSphere bSphere,
                            BranchGroup branchGroup,
                            SharedGroup sharedGroup) {
        TransformGroup transformGroupT;
        TransformGroup transformGroupR;
        Billboard billboard;
        for (int i = 0; i < position.length; i++) {
            translateV3f.set(position[i]);
            transform3D.setTranslation(translateV3f);
            transformGroupT = new TransformGroup(transform3D);
            transformGroupR = new TransformGroup();
            transformGroupR.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
            billboard = new Billboard(transformGroupR);
            billboard.setSchedulingBounds(bSphere);
            billboard.setAlignmentMode(Billboard.ROTATE_ABOUT_POINT);
            branchGroup.addChild(transformGroupT);
            branchGroup.addChild(billboard);
            transformGroupT.addChild(transformGroupR);
            transformGroupR.addChild(new Link(sharedGroup));
        }
    }

    GunController gc = null;

    public DoomKeyboard() {

        Canvas3D c3d = Gutils.getCanvas3D(this);

        setLayout(new BorderLayout());
        add("Center", c3d);

        // SimpleUniverse is a Convenience Utility class
        //SimpleUniverse su = new SimpleUniverse(c3d);
        BasicUniverse su = setUpBasicUniverse(c3d);

        //ViewingPlatform viewingPlatform = su.getViewingPlatform();
        //viewTransformGroup
        //        = viewingPlatform.getViewPlatformTransform();
        viewTransformGroup = su.getViewTransformGroup();
        gc = new GunController();
        gc.setCanvas3D(c3d);
        c3d.addKeyListener(gc);


        su.addBranchGraph(getSceneBranchGroup(viewTransformGroup));
    }

    private BasicUniverse setUpBasicUniverse(Canvas3D c3d) {
        BasicUniverse su = new BasicUniverse(c3d, 10);
        su.addBranchGraph(createBackground(this));
        su.addBranchGraph(this.getBulletGroup());
        return su;
    }

    TransformGroup viewTransformGroup = null;
    private View view = null;


    BoundingSphere getBackgroundBoundingSphere() {
        //return new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 200.0);
        return new BoundingSphere();
    }

    public static BranchGroup createBackground(DoomKeyboard levitown) {
        // create a parent BranchGroup for the Background
        BranchGroup backgroundGroup = new BranchGroup();

        // create a new Background node
        Background back = new Background();

        // set the range of influence of the background
        back.setApplicationBounds(levitown.getBackgroundBoundingSphere());

        // create a BranchGroup that will hold
        // our Sphere geometry
        BranchGroup bgGeometry = new BranchGroup();

        // create the Sphere geometry with radius 1.0
        // we tell the Sphere to generate texture coordinates
        // to enable the texture image to be rendered
        // and because we are *inside* the Sphere we have to generate
        // Normal coordinates inwards or the Sphere will not be visible.
        Appearance appearance = new Appearance();
        appearance.setTexture(Gutils.getMandleTexture(640, 480));
        Sphere sphere = new Sphere(0.50f,
                Primitive.GENERATE_TEXTURE_COORDS |
                Primitive.GENERATE_NORMALS_INWARD,
                appearance);

        // start wiring everything together
        // add the Sphere to its parent BranchGroup
        bgGeometry.addChild(sphere);

        // assign the BranchGroup to the Background as geometry.
        back.setGeometry(bgGeometry);

        // add the Background node to its parent BranchGroup
        backgroundGroup.addChild(back);

        return backgroundGroup;
    }

    protected BranchGroup getJoeGroup() {
        BranchGroup theJoeSphere = new BranchGroup();

        BranchGroup s1 = getJoeSphere("gifs\\animation3.gif");
        BranchGroup s2 = getDeadJoeSphere("shuttle\\aw626.jpg");

        TransformGroup joeRotXfmGrp = new TransformGroup();
        Transform3D joeRotXfm = new Transform3D();
        Matrix3d joeRotMat = new Matrix3d();
        joeRotMat.rotY(Math.PI / 2);
        joeRotXfm.set(joeRotMat, new Vector3d(0.0, 0.0, -30.0), 1.0);
        joeRotXfmGrp.setTransform(joeRotXfm);
        joeRotXfmGrp.addChild(joeSwitch);

        joeSwitch.addChild(s1);
        joeSwitch.addChild(s2);


        targetTransformGroup.setCapability(TransformGroup.ALLOW_TRANSFORM_READ);
        targetTransformGroup.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
        targetTransformGroup.addChild(joeRotXfmGrp);

        Transform3D axis = new Transform3D();
        PositionInterpolator moveJoe =
                new PositionInterpolator(joeAlpha,
                        targetTransformGroup,
                        axis,
                        -50.0f, 50.0f);
        BoundingSphere bs = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 200);
        moveJoe.setSchedulingBounds(bs);
        theJoeSphere.addChild(moveJoe);
        theJoeSphere.addChild(targetTransformGroup);
        return theJoeSphere;
    }

    public static Switch getJoeSwitch() {
        Switch s = new Switch(0);
        s.setCapability(Switch.ALLOW_SWITCH_WRITE);
        return s;
    }

    protected BranchGroup getJoeSphere(String img) {
        BranchGroup theJoeSphere = new BranchGroup();
        String img1 = img;
        theJoeSphere = (Gutils.getTextureSphere(1.5, 0, 1.125, img1));
        return theJoeSphere;
    }

    private BranchGroup getDeadJoeSphere(String img) {
        BranchGroup theJoeSphere = new BranchGroup();
        String img1 = img;
        joeSwitch.addChild(Gutils.getTextureSphere(1.5, 0, 1.125, img1));
        return theJoeSphere;
    }


    public static PlatformGeometry buildGunPlatform() {
        BranchGroup theGun = new BranchGroup();
        Appearance gunApp = new Appearance();
        Color3f ambientColour = new Color3f(0.5f, 0.5f, 0.5f);
        Color3f emissiveColour = new Color3f(0.0f, 0.0f, 0.0f);
        Color3f specularColour = new Color3f(1.0f, 1.0f, 1.0f);
        Color3f diffuseColour = new Color3f(0.5f, 0.5f, 0.5f);
        float shininess = 20.0f;
        gunApp.setMaterial(new Material(ambientColour, emissiveColour,
                diffuseColour, specularColour, shininess));

        TransformGroup initTransformGroup = new TransformGroup();
        TransformGroup barrelTransformGroup = new TransformGroup();

        Transform3D gunXfm = new Transform3D();
        Transform3D barrelXfm = new Transform3D();
        barrelXfm.set(new Vector3d(0, -2.0, 1));
        barrelTransformGroup.setTransform(barrelXfm);
        Matrix3d gunXfmMat = new Matrix3d();
        gunXfmMat.rotX(Math.PI / 2);
        gunXfm.set(gunXfmMat);
        // lets try this..
        initTransformGroup.setCapability(TransformGroup.ALLOW_TRANSFORM_READ);
        initTransformGroup.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
        barrelTransformGroup.addChild(new Cylinder(0.3f, 7.0f, gunApp));

        theGun.addChild(initTransformGroup);

        PlatformGeometry pg = new PlatformGeometry();
        pg.addChild(theGun);
        return pg;
    }

    protected BranchGroup buildGun(TransformGroup transformGroup) {
        BranchGroup theGun = new BranchGroup();
        Appearance gunApp = new Appearance();
        Color3f ambientColour = new Color3f(0.5f, 0.5f, 0.5f);
        Color3f emissiveColour = new Color3f(0.0f, 0.0f, 0.0f);
        Color3f specularColour = new Color3f(1.0f, 1.0f, 1.0f);
        Color3f diffuseColour = new Color3f(0.5f, 0.5f, 0.5f);
        float shininess = 20.0f;
        gunApp.setMaterial(new Material(ambientColour, emissiveColour,
                diffuseColour, specularColour, shininess));

        TransformGroup initTransformGroup = new TransformGroup();
        TransformGroup barrelTransformGroup = new TransformGroup();

        Transform3D gunXfm = new Transform3D();
        Transform3D barrelXfm = new Transform3D();
        barrelXfm.set(new Vector3d(0, -2.0, 1));
        barrelTransformGroup.setTransform(barrelXfm);
        Matrix3d gunXfmMat = new Matrix3d();
        gunXfmMat.rotX(Math.PI / 2);
        gunXfm.set(gunXfmMat);
        gunTransformGroup.setTransform(gunXfm);
        // lets try this..
        initTransformGroup.setCapability(TransformGroup.ALLOW_TRANSFORM_READ);
        initTransformGroup.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
        keyNavBeh.setGunTransformGroup(initTransformGroup);
        keyNavBeh.setBulletTransformGroup(bulletTransformGroup);
        keyNavBeh.setTargetTransformGroup(targetTransformGroup);
        gc.setTransformGroup(gunTransformGroup);

        gunTransformGroup.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
        //gunXfmGrp.addChild(new Box(1.0f, 1.0f, 0.5f, gunApp));
        barrelTransformGroup.addChild(new Cylinder(0.3f, 7.0f, gunApp));
        gunTransformGroup.addChild(barrelTransformGroup);
        theGun.addChild(initTransformGroup);
        initTransformGroup.addChild(gunTransformGroup);
        return theGun;
    }

    protected BranchGroup getBulletGroup() {
        BranchGroup bulletBranchGroup = new BranchGroup();

        Appearance bulletAppearance = new Appearance();
        Color3f ambientColour = new Color3f(1.0f, 0.0f, 0.0f);
        Color3f emissiveColour = new Color3f(0.0f, 0.0f, 0.0f);
        Color3f specularColour = new Color3f(1.0f, 1.0f, 1.0f);
        Color3f diffuseColour = new Color3f(1.0f, 0.0f, 0.0f);
        float shininess = 20.0f;
        bulletAppearance.setMaterial(new Material(ambientColour, emissiveColour,
                diffuseColour, specularColour, shininess));

        Sphere bulletSphere = new Sphere(0.2f, bulletAppearance);


        bulletTransformGroup.addChild(bulletSphere);
        bulletBranchGroup.addChild(bulletTransformGroup);

        bulletPositionInterpolator = new PositionInterpolator(ballAlpha,
                bulletTransformGroup,
                new Transform3D(), 0.0f, 50.0f);
        bulletPositionInterpolator.setSchedulingBounds(bounds);
        bulletBranchGroup.addChild(bulletPositionInterpolator);

        return bulletBranchGroup;

    }


    public static void main(String[] args) {
        new MainFrame(new DoomKeyboard(), 400, 400);
    } // end of main (method of BillboardApp)
}
