package j3d.utils;

import com.sun.j3d.utils.universe.ViewingPlatform;

import javax.media.j3d.*;
import javax.vecmath.Vector3f;

/**
 * DocJava, Inc.
 * http://www.docjava.com
 * Programmer: dlyon
 * Date: Mar 30, 2004
 * Time: 3:26:29 PM
 */
public class BasicUniverse {
    private VirtualUniverse universe = new VirtualUniverse();
    private Locale locale = new Locale(universe);
    private BranchGroup viewBranchGroup = Gutils.getBranchGroup();
    private TransformGroup viewTransformGroup = Gutils.getTransformGroup();
    private ViewPlatform viewPlatform = Gutils.getViewPlatform();
    private ViewingPlatform viewingPlatform = new ViewingPlatform();
    private View view = new View();
    private Canvas3D canvas3d;
    private float zViewingDistance;

    public Transform3D getViewTransform3D() {
        Transform3D t3d = new Transform3D();
        viewTransformGroup.getTransform(t3d);
        return t3d;
    }
    public BasicUniverse(Canvas3D canvas3d, float zViewingDistance){
        this.canvas3d = canvas3d;

        this.zViewingDistance = zViewingDistance;
        Gutils.addKeyboardNavigation(viewTransformGroup,viewBranchGroup);
        setupViewPlatform();
        viewBranchGroup.addChild(viewTransformGroup);
        setupView(canvas3d);
        view.attachViewPlatform(viewPlatform);
        locale.addBranchGraph(viewBranchGroup);
    }
    public ViewPlatform getViewPlatform() {
        return viewPlatform;
    }
    private void setupView(Canvas3D c){
        view.addCanvas3D(c);
        view.setPhysicalBody(new PhysicalBody());
        view.setPhysicalEnvironment(new PhysicalEnvironment());
    }
    private void setupViewPlatform(){
        //viewingPlatform.addChild(viewPlatform);
        setViewingDistance(zViewingDistance);
        viewTransformGroup.addChild(viewPlatform);
    }
    public void setViewingDistance(float viewDistance){
        zViewingDistance = viewDistance;
        Transform3D transform = new Transform3D();
        transform.set(new Vector3f(0,0,zViewingDistance));
        viewTransformGroup.setTransform(transform);
    }
    public void addBranchGraph(BranchGroup bg){
        locale.addBranchGraph(bg);
    }
    public TransformGroup getViewTransformGroup(){
        return viewTransformGroup;
    }
    public View getView() {
        return view;
    }

}
