package j3d.killTheStudent;

/**
 * Created by IntelliJ IDEA.
 * User: jgervasio
 * Date: Feb 23, 2004
 * Time: 12:11:58 PM
 * To change this template use Options | File Templates.
 */


import com.sun.j3d.utils.applet.MainFrame;
import com.sun.j3d.utils.universe.SimpleUniverse;
import com.sun.j3d.utils.universe.ViewingPlatform;
import j3d.examples.GunController;
import j3d.killTheStudent.KeyBehavior2;
import j3d.utils.ShapeCollection;
import j3d.utils.ShapeCollection;

import javax.media.j3d.*;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import java.applet.Applet;
import java.awt.*;


//   BillboardApp renders a simple landscape with billboard animated trees

public class DoomKeyboard extends Applet {

    Alpha joeAlpha = new Alpha(-1, 0, 0, 4000, 0, 0);
    private BoundingSphere bounds
            = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
    public static Switch joeSwitch = JoeSphere.getJoeSwitch();

    public BranchGroup getSceneBranchGroup(TransformGroup viewTransformGroup) {

        BranchGroup bg = new BranchGroup();

        Vector3f translate = new Vector3f();
        Transform3D T3D = new Transform3D();

        BoundingSphere bs = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 20000);
        bg.addChild(ShapeCollection.getLand());

        AddSceneGeometry.addTrees(this, translate, T3D, bs, bg);
        AddSceneGeometry.addHouses(this, translate, T3D, bs, bg);
        //AddSceneGeometry.addTanks(this, translate, T3D, bs, bg);

        raiseViewAboveGround(translate, T3D, viewTransformGroup);
        addKeyboardNavigation(viewTransformGroup, bg);

        BranchGroup textureSphere = new BranchGroup();
        textureSphere.addChild(JoeSphere.getJoeGroup(this));
        bg.addChild(textureSphere);


        Matrix3d viewTilt = new Matrix3d();
        viewTilt.rotX(Math.PI / -6);
        T3D.set(viewTilt, new Vector3d(0.0, 10.0, 10.0), 1.0);

        TransformGroup viewXfmGroup = new TransformGroup(T3D);
        //ViewPlatform myViewPlatform = new ViewPlatform();
        PhysicalBody myBody = new PhysicalBody();
        PhysicalEnvironment myEnvironment = new PhysicalEnvironment();
        //viewXfmGroup.addChild(myViewPlatform);
        bg.addChild(viewXfmGroup);

        view = new View();
        //myView.addCanvas3D(Utils.getCanvas3D(this));
        //myView.attachViewPlatform(myViewPlatform);
        view.setPhysicalBody(myBody);
        view.setPhysicalEnvironment(myEnvironment);
        //gc.setView(view);
        bg.compile();
        return bg;
    } // end of CreateSceneGraph method of BillboardApp

    KeyBehavior2 keyNavBeh = null;


    public void addKeyboardNavigation(TransformGroup transformGroup, BranchGroup bg) {
        keyNavBeh = new KeyBehavior2(transformGroup);
        keyNavBeh.setSchedulingBounds(new BoundingSphere(new Point3d(), 10000.0));

        BranchGroup bulletBranchGroup = new BranchGroup();
        keyNavBeh.setGunTransformGroup();
        bulletBranchGroup = TheGun.getBulletGroup(this);
        bg.addChild(keyNavBeh);

        bg.addChild(bulletBranchGroup);
    }

     private void raiseViewAboveGround(Vector3f translate, Transform3D t3D, TransformGroup tg) {
        translate.set(0.0f, 0.3f, 0.0f);
        t3D.setTranslation(translate);
        tg.setTransform(t3D);
    }

     public DoomKeyboard() {

        Canvas3D c3d = Utils.getCanvas3D(this);

        setLayout(new BorderLayout());
        add("Center", c3d);

        // SimpleUniverse is a Convenience Utility class
        SimpleUniverse su = new SimpleUniverse(c3d);

        ViewingPlatform vp = su.getViewingPlatform();
        vp.setNominalViewingTransform();

        vp.setPlatformGeometry(TheGun.buildGunPlatform());
        TransformGroup steerTg = vp.getViewPlatformTransform();

        Transform3D t3d = new Transform3D();
        steerTg.getTransform(t3d);

        su.addBranchGraph(AddSceneGeometry.createBackground(this));

        viewTransformGroup
                = su.getViewingPlatform().getViewPlatformTransform();

        su.addBranchGraph(getSceneBranchGroup(viewTransformGroup));
    }

    TransformGroup viewTransformGroup = null;
    private View view = null;


    BoundingSphere getBackgroundBoundingSphere() {
        //return new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 200.0);
        return new BoundingSphere();
    }

    BoundingSphere getBoundingSphere() {
        return  bounds;
    }

    /*public static void main(String[] args) {
        new MainFrame(new MyLevittownDoomKeyboard(), 700, 600);
    } // end of main (method of BillboardApp)
    */
}
