package j3d.examples.texture;

import com.sun.j3d.utils.applet.MainFrame;
import com.sun.j3d.utils.geometry.Box;
import com.sun.j3d.utils.universe.SimpleUniverse;
import j3d.utils.Gutils;
import j3d.utils.Gutils;

import javax.media.j3d.*;
import java.applet.Applet;
import java.awt.*;
import java.awt.event.KeyEvent;
import java.util.Enumeration;


/**
 * Create  a mandlebrot set for a box the user rotates
 * with a keystroke.
 */
public final class MandleBox extends Applet {
    /**
     * a class that lets the user
     * rotate the object with the keyboard.
     */
    public static final class SimpleBehavior extends Behavior {

        private final TransformGroup targetTG;
        private final Transform3D t3d = new Transform3D();
        final Transform3D rotz = new Transform3D();
        private double angle = 0.0;


        SimpleBehavior(final TransformGroup targetTG) {
            this.targetTG = targetTG;
        }

        public void initialize() {

            this.wakeupOn(new WakeupOnAWTEvent(KeyEvent.KEY_PRESSED));
        }

        public void processStimulus(final Enumeration criteria) {
            angle += 0.1;
            t3d.rotY(angle);
            rotz.rotZ(angle * .1);
            t3d.mul(rotz);
            targetTG.setTransform(t3d);
            this.wakeupOn(new WakeupOnAWTEvent(KeyEvent.KEY_PRESSED));
        }

    }

    private static Appearance getAppearance() {
        final Appearance app = new Appearance();
        app.setTexture(Gutils.getMandleTexture(400, 400));
        return app;
    }

    private static BranchGroup createSceneGraph() {

        final BranchGroup objRoot = new BranchGroup();

        final TransformGroup objRotate = new TransformGroup();
        objRotate.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);

        objRoot.addChild(objRotate);
        final Box b = new Box(.4f, .4f, .4f,
                Box.GENERATE_TEXTURE_COORDS, getAppearance());
        objRotate.addChild(b);

        final SimpleBehavior myRotationBehavior = new SimpleBehavior(objRotate);
        myRotationBehavior.setSchedulingBounds(new BoundingSphere());
        objRoot.addChild(myRotationBehavior);
        objRoot.compile();

        return objRoot;
    }


    /**
     * create a simple scene and attach it to the
     * virtual universe.
     */
    public MandleBox() {
        setLayout(new BorderLayout());

        final Canvas3D canvas3D
                = new Canvas3D(SimpleUniverse.getPreferredConfiguration());
        add("Center", canvas3D);
        final SimpleUniverse su = new SimpleUniverse(canvas3D);
        final BranchGroup scene = createSceneGraph();

        su.getViewingPlatform().setNominalViewingTransform();

        su.addBranchGraph(scene);
    }

    /**
     * ignore the args.
     *
     * @param args args unused.
     */
    public static void main(final String[] args) {
        new MainFrame(new MandleBox(), 256, 256);
    } // end of main (method of SimpleBehaviorApp)

} // end of class SimpleBehaviorApp
