/*
    Earth.java
    Program to display rotating earth
    By Roger T. Stevens  4-5-99
*/
package j3d.examples;

import com.sun.j3d.utils.applet.MainFrame;
import j3d.utils.BasicUniverse;
import j3d.utils.Gutils;
import utils.ResourceManager;

import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import java.applet.Applet;
import java.awt.*;

public class SpinningEarth extends Applet {

    public SpinningEarth() {
        Canvas3D c = Gutils.getCanvas3D(this);
        add(c, BorderLayout.CENTER);

        BranchGroup bg = Gutils.getTextureSphere(0.5,
                0, 0, ResourceManager.getImageFile(
                        "earth.jpg").getAbsolutePath());
        BasicUniverse u = new BasicUniverse(c,10);
        u.addBranchGraph(bg);
    }

    public static void main(String[] args) {
        new MainFrame(new SpinningEarth(), 200, 200);
    }
}
